package com.ejianc.business.tradematerial.settlement.service;

import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.settlement.bean.SettlementEntity;
import com.ejianc.business.tradematerial.settlement.vo.*;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 结算单主表
 * 
 * @author generator
 * 
 */
public interface ISettlementService extends IBaseService<SettlementEntity> {
    CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO);
    CommonResponse<Map> getDateMny(Long contractId);
    CommonResponse<String> delete(List<SettlementVO> vos);
    boolean pushBillToSupCenter(SettlementEntity entity, String billTypeCode);
    CommonResponse<String> updatePushBill(SettlementEntity entity, String billTypeCode, String url);
    String updateBillSupSignSyncInfo(HttpServletRequest request);
    boolean pushSettleToPool(SettlementVO vo);
    boolean delSettleFromPool(Long id);
    ExecutionVO targetCost(SettlementVO settlementVO, String linkUrl, Integer settlementType);
    SettlementRecordVO querySettleRecord(Long contractId);
    ParamsCheckVO checkParams(SettlementVO settlementVO);
    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    List<ParamsCheckVO> checkParamsMnyList(ContractEntity contractEntity, SettlementVO vo);
    /**
     * 单据管控-累计结算数量大于合同数量
     * @return
     */
    List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, SettlementVO vo);
    CommonResponse<String> pushTargetCost(Long id);

    /**
     * 根据合同id查询当前合同下结算列表
     * @param contractId 合同id
     * @return 查询结果
     */
    ContractSettlementRecordVO queryDetailRecord(Long contractId);
    void updateContractPoolSettle(SettlementVO vo, Boolean type);
    /*历史价 控 明细价
     *        @param 最新合同vo  或 协议vo

     * */
    ParamsCheckVO priceCheckParams(SettlementVO vo);
    void costPush(SettlementEntity entity);
    CommonResponse<SettlementVO> pushCost(SettlementVO vo);

    /**
     * 根据合同id查询对应的结算列表
     *
     * @param settlementVO 合同id、结算类型
     * @return 查询结果
     */
    List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO);

    /**
     * 单据管控-单次无合同结算金额控制
     *
     * @param vo 结算信息
     * @return 控制结果
     */
    List<ParamsCheckVO> checkParamsMny(SettlementVO vo);

    /**
     * 单据管控-单个供应商无合同结算金额控制
     *
     * @param vo 结算信息
     * @return 控制结果
     */
    List<ParamsCheckVO> checkParamsMnyBySupplier(SettlementVO vo);

    /*
     * 【施工合同金额】控【无合同结算、零星机械金额】*/
    List<ParamsCheckVO> checkParamsConstruction(SettlementVO vo);

    /**
     * 查询打印结算单材料明细，按子表材料+入库单价+结算单价  一致时合并；
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO);

    /**
     * 查询打印结算单其他费用，当其他费用来源于合同同一清单时，合并
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO);
}
