/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMZZCRKDApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCRKDVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.tradematerial.check.bean.CheckDetailEntity;
import com.ejianc.business.tradematerial.check.bean.CheckEntity;
import com.ejianc.business.tradematerial.check.service.ICheckService;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.enums.BillPushStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.sign.api.ISignApi;
import com.ejianc.foundation.sign.vo.SignVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String OPERATE = "XHC_CHECK_SYNC";
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IPMZZCRKDApi ipmzzcrkdApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220215000000006";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/materialCheck/deleteCheck";
    private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ISignApi signApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        CheckEntity checkEntity;
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u540e\u56de\u8c03\uff0csign\uff1a{}", (Object)sign);
        if ("wuzizhuguan".equals(sign) && (checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId))) != null) {
            this.logger.info("InvocationInfoProxy.getUserid()\uff1a{}", (Object)InvocationInfoProxy.getUserid());
            CommonResponse listCommonResponse = this.signApi.queryByUserIdList(Arrays.asList(InvocationInfoProxy.getUserid()));
            this.logger.info("listCommonResponse\uff1a{}", (Object)JSONObject.toJSONString((Object)listCommonResponse));
            if (listCommonResponse.getCode() == 0) {
                for (SignVO datum : (List)listCommonResponse.getData()) {
                    if (!datum.getDefaultFlag().booleanValue()) continue;
                    checkEntity.setUrlWz(datum.getFileUrl());
                    this.logger.info("\u56fe\u7247\u5730\u5740\u8d4b\u503c\u6210\u529f\uff0cUrlWz\uff1a{}", (Object)datum.getFileUrl());
                    this.checkService.saveOrUpdate((Object)checkEntity);
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List<CheckDetailEntity> checkDetailEntity;
        FlowVO flowVO;
        ArrayList<FlowVO> flowVOS;
        StoreManageVO storeManageVO;
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        ContractEntity contractEntity = null;
        if (checkEntity.getContractId() != null) {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkEntity.getContractId()));
        }
        checkEntity.setCheckState(1);
        this.checkService.updateById((Object)checkEntity);
        if (checkEntity.getStoreType() == 0) {
            storeManageVO = new StoreManageVO();
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93);
                storeManageVO.setStoreId(checkEntity.getProjectId());
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2")) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
                storeManageVO.setStoreId(checkEntity.getStoreId());
            }
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setSourceId(checkEntity.getId());
            flowVOS = new ArrayList<FlowVO>();
            for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
                flowVO = new FlowVO();
                if (checkEntity.getCheckType().equals("proMaterial-2")) {
                    flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93, (Integer)0);
                }
                if (!checkEntity.getCheckType().equals("proMaterial-2")) {
                    flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
                }
                this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u9a8c\u6536\u5165\u5e93\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
            }
        }
        if (checkEntity.getStoreType() == 1) {
            storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setSourceId(checkEntity.getId());
            flowVOS = new ArrayList();
            for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
                flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93, (Integer)0);
                this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            ArrayList<FlowVO> flowOutS = new ArrayList<FlowVO>();
            for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
                FlowVO flowVO2 = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u51fa\u5e93, (Integer)0);
                this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO2, contractEntity);
                flowOutS.add(flowVO2);
            }
            storeManageVO.setStraightOutFlowVOList(flowOutS);
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u76f4\u5165\u76f4\u51fa\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            this.logger.info("\u6d4b\u8bd5\u62a5\u951903" + response.getMsg());
            if (!response.isSuccess()) {
                this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
            }
        }
        if (checkEntity.getCheckType().equals("proMaterial-2") && "common".equals(this.GenerateBillCodeType) && CollectionUtils.isNotEmpty(checkDetailEntity = checkEntity.getCheckDetailList())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ArrayList list = new ArrayList();
            checkDetailEntity.forEach(e -> {
                PMZZCRKDVO vo = new PMZZCRKDVO();
                vo.setContractId(checkEntity.getContractId() == null ? "" : checkEntity.getContractId().toString());
                vo.setProjectId(checkEntity.getProjectId() == null ? "" : checkEntity.getProjectId().toString());
                vo.setCheckDate(sdf.format(checkEntity.getCheckDate()));
                vo.setMaterialId(e.getMaterialId() == null ? "" : e.getMaterialId().toString());
                vo.setMaterialName(e.getMaterialName());
                vo.setMaterialTypeName(e.getMaterialTypeName());
                vo.setSpec(e.getSpec());
                vo.setUnitName(e.getUnit());
                vo.setCheckNum(e.getCheckNum());
                vo.setCheckTaxMny(e.getCheckTaxMny());
                vo.setSourceId(e.getId().toString());
                vo.setCheckMny(e.getCheckMny());
                vo.setTaxMny(e.getTaxMny());
                list.add(vo);
            });
            this.logger.info("\u5468\u8f6c\u6750\u8c03\u7528\u8d22\u52a1\u53c2\u6570\uff1a" + JSONObject.toJSONString(list));
            this.ipmzzcrkdApi.saveOrUpdate(list);
        }
        return CommonResponse.success();
    }

    private void getFlow(CheckEntity checkEntity, CheckDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        if ("proMaterial-2".equals(checkEntity.getCheckType())) {
            flowVO.setStoreId(checkEntity.getProjectId());
            flowVO.setStoreName(checkEntity.getProjectName());
        }
        if (!"proMaterial-2".equals(checkEntity.getCheckType())) {
            flowVO.setStoreId(checkEntity.getStoreId());
            flowVO.setStoreName(checkEntity.getStoreName());
        }
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSubSupplierId());
        flowVO.setPickUnitName(checkEntity.getSubSupplierName());
        flowVO.setPickContractId(checkEntity.getSubContractId());
        flowVO.setPickContractName(checkEntity.getSubContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("\u6750\u6599\u9a8c\u6536");
        flowVO.setSourceBillTypeCode(BILL_TYPE);
        flowVO.setSourceType(checkEntity.getSourceType());
        flowVO.setPickType(checkEntity.getSubOutType());
        flowVO.setLicensePlate(checkEntity.getLicensePlate());
        if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 1) {
            flowVO.setPickTypeName("\u5185\u90e8\u9886\u6599");
        }
        if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 2) {
            flowVO.setPickTypeName("\u5206\u5305\u9886\u6599");
        }
        if (null != checkEntity.getContractId() && null != contractEntity) {
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            Map sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
            Map DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
            ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)sourceIdMap.get(t.getSourceId()));
            if (null != contractDetailEntity) {
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            } else {
                contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(t.getMaterialId()));
                if (null != contractDetailEntity) {
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                } else {
                    contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(t.getMaterialTypeId()));
                    if (null != contractDetailEntity) {
                        flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        flowVO.setContractPrice(contractDetailEntity.getPrice());
                    } else {
                        flowVO.setContractTaxPrice(BigDecimal.ZERO);
                        flowVO.setContractPrice(BigDecimal.ZERO);
                    }
                }
            }
        }
        flowVO.setRowState(t.getRowState());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (checkEntity.getSignStatus() == 1) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List<CheckDetailEntity> checkDetailEntity;
        CommonResponse response;
        String stringInfo;
        StoreManageVO storeManageVO;
        ArrayList<Long> ids;
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9a8c\u6536\u5355Id---{}", (Object)checkEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(checkEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)"0");
        this.checkService.update((Wrapper)updateWrapper);
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(checkEntity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            checkEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.checkService.saveOrUpdate((Object)checkEntity, false);
        }
        if (checkEntity.getStoreType() == 0) {
            ids = new ArrayList<Long>();
            ids.add(billId);
            storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(checkEntity.getId());
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93);
                storeManageVO.setStoreId(checkEntity.getProjectId());
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2")) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
                storeManageVO.setStoreId(checkEntity.getStoreId());
            }
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        if (checkEntity.getStoreType() == 1) {
            ids = new ArrayList();
            ids.add(billId);
            storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setSourceId(checkEntity.getId());
            storeManageVO.setSourceIdsForRollBack(ids);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        if (checkEntity.getCheckType().equals("proMaterial-2") && "common".equals(this.GenerateBillCodeType) && CollectionUtils.isNotEmpty(checkDetailEntity = checkEntity.getCheckDetailList())) {
            ArrayList list = new ArrayList();
            checkDetailEntity.forEach(e -> list.add(e.getId().toString()));
            this.logger.info("\u5f03\u5ba1\u5468\u8f6c\u6750\u8c03\u7528\u8d22\u52a1\u53c2\u6570\uff1a" + JSONObject.toJSONString(list));
            this.ipmzzcrkdApi.delete(list);
        }
        return CommonResponse.success();
    }
}

