/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.vo.ContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractDetail"})
@Api(value="\u4e3b\u5408\u540c\u660e\u7ec6\u5b9e\u4f53", tags={"\u4e3b\u5408\u540c\u660e\u7ec6\u5b9e\u4f53"})
public class ContractDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractDetailVO saveorUpdateVO) {
        ContractDetailEntity entity = (ContractDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ContractDetailVO vo = (ContractDetailVO)BeanMapper.map((Object)((Object)entity), ContractDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractDetailVO> queryDetail(@RequestParam Long id) {
        ContractDetailEntity entity = (ContractDetailEntity)((Object)this.service.selectById(id));
        ContractDetailVO vo = (ContractDetailVO)BeanMapper.map((Object)((Object)entity), ContractDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractDetailVO contractDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractDetail-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refContractDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("contractId", new Parameter("eq", (Object)Long.valueOf(String.valueOf(_con.get((Object)"contractId")))));
            param.getParams().put("materialId", new Parameter("ne", null));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5206\u7c7b\u4e0b\u7269\u8d44\u53c2\u7167")
    @RequestMapping(value={"/refContractDetailTypeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractDetailTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        Integer size = 0;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"contractId")) {
            param.getParams().put("contractId", new Parameter("eq", (Object)Long.valueOf(String.valueOf(_con.get((Object)"contractId")))));
            param.getParams().put("materialId", new Parameter("eq", null));
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List contractDetailType = this.service.queryList(param, false);
        if (CollectionUtils.isEmpty((Collection)contractDetailType)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List collect = contractDetailType.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null).map(t -> t.getMaterialTypeId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        Map<Long, ContractDetailEntity> contractMapType = contractDetailType.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        CommonResponse response = this.materialApi.queryMaterialByCategoryId(collect);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        List<MaterialVO> list = this.pageList((List)response.getData(), pageSize, pageNumber, searchText);
        size = ((List)response.getData()).size();
        ArrayList<ContractDetailVO> detailList = new ArrayList<ContractDetailVO>();
        for (MaterialVO materialVO : list) {
            if (!contractMapType.containsKey(materialVO.getCategoryId())) continue;
            ContractDetailEntity contractDetailEntity = contractMapType.get(materialVO.getCategoryId());
            contractDetailEntity.setId(materialVO.getId());
            contractDetailEntity.setMaterialCode(materialVO.getCode());
            contractDetailEntity.setMaterialId(materialVO.getId());
            contractDetailEntity.setMaterialName(materialVO.getName());
            contractDetailEntity.setSpec(materialVO.getSpec());
            contractDetailEntity.setUnitName(materialVO.getUnitName());
            ContractDetailVO map = (ContractDetailVO)BeanMapper.map((Object)((Object)contractDetailEntity), ContractDetailVO.class);
            detailList.add(map);
        }
        pageData.setRecords(detailList);
        pageData.setTotal((long)size.intValue());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public List<MaterialVO> pageList(List<MaterialVO> dataList, int pageSize, int pageNo, String searchText) {
        ArrayList<MaterialVO> currentPageList = new ArrayList<MaterialVO>();
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            dataList = dataList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getName()) && item.getName().contains(searchText) || StringUtils.isNotEmpty((CharSequence)item.getCode()) && item.getCode().contains(searchText) || StringUtils.isNotEmpty((CharSequence)item.getSpec()) && item.getSpec().contains(searchText) || StringUtils.isNotEmpty((CharSequence)item.getCategoryName()) && item.getCategoryName().contains(searchText)).collect(Collectors.toList());
        }
        if (dataList != null && dataList.size() > 0) {
            int currIdx = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                MaterialVO data = (MaterialVO)dataList.get(currIdx + i);
                currentPageList.add(data);
            }
        }
        return currentPageList;
    }

    @ApiOperation(value="\u67e5\u8be2\u660e\u7ec6\u5217\u8868")
    @RequestMapping(value={"/getContractDetailByTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getContractDetailByTree(@RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.getContractDetailByTree(contractId));
    }

    @ApiOperation(value="\u67e5\u8be2\u660e\u7ec6\u5217\u8868")
    @RequestMapping(value={"/getContractDetailByTable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getContractDetailByTable(@RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.getContractDetailByTable(contractId));
    }

    @ApiOperation(value="\u67e5\u8be2\u660e\u7ec6\u5217\u8868\u8be6\u60c5")
    @RequestMapping(value={"/getContractDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractDetailVO>> getContractDetail(@RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.service.getContractDetail(contractId));
    }
}

