/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tradematerial.finance.bean.PaymentRegisterEntity;
import com.ejianc.business.tradematerial.finance.bean.RegisterDetailEntity;
import com.ejianc.business.tradematerial.finance.enums.PaymentContractEnum;
import com.ejianc.business.tradematerial.finance.service.IPaymentRegisterService;
import com.ejianc.business.tradematerial.finance.vo.PaymentRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"paymentRegister"})
public class PaymentRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PAYMENT_REGISTER";
    @Autowired
    private IPaymentRegisterService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaymentRegisterVO> saveOrUpdate(@RequestBody PaymentRegisterVO paymentRegisterVO) {
        PaymentRegisterEntity entity = (PaymentRegisterEntity)((Object)BeanMapper.map((Object)paymentRegisterVO, PaymentRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)paymentRegisterVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u4ed8\u6b3e\u767b\u8bb0\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getSourceId() != null) {
                this.service.checkStatus(paymentRegisterVO);
            }
        }
        if (entity.getPaymentContractFlag() != 0 || entity.getPaymentContractFlag() != 1) {
            this.service.updateStatus(entity, 0);
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            for (RegisterDetailEntity detail : entity.getDetailList()) {
                detail.setBillState(0);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PaymentRegisterVO vo = (PaymentRegisterVO)BeanMapper.map((Object)((Object)entity), PaymentRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentRegisterVO> queryDetail(Long id) {
        PaymentRegisterEntity entity = (PaymentRegisterEntity)((Object)this.service.selectById(id));
        PaymentRegisterVO vo = (PaymentRegisterVO)BeanMapper.map((Object)((Object)entity), PaymentRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentRegisterVO> vos) {
        for (PaymentRegisterVO vo : vos) {
            PaymentRegisterEntity paymentRegisterEntity = (PaymentRegisterEntity)((Object)this.service.selectById(vo.getId()));
            if (paymentRegisterEntity.getPaymentContractFlag() == 0 || paymentRegisterEntity.getPaymentContractFlag() == 1) continue;
            this.service.updateStatus(paymentRegisterEntity, 1);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if (null == param.getParams().get("orgId")) {
            orgId = InvocationInfoProxy.getOrgId();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                resp.put("current", (Object)param.getPageIndex());
                resp.put("size", (Object)param.getPageSize());
                resp.put("pages", (Object)0);
                resp.put("totalMny", (Object)0);
                resp.put("total", (Object)0);
                resp.put("records", new ArrayList());
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
            }
        }
        IPage page = this.service.queryPage(param, false);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("totalMny", (Object)this.service.getTotalPaidMny(param));
        resp.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), PaymentRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List paymentRegisterVOList = new ArrayList();
        if (null != commonResponse.getData() && CollectionUtils.isNotEmpty(paymentRegisterVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records"))) {
            for (PaymentRegisterVO paymentRegisterVO : paymentRegisterVOList) {
                paymentRegisterVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)paymentRegisterVO.getBillState()).getDescription());
                paymentRegisterVO.setPaymentContractFlagName(PaymentContractEnum.getByCode((Integer)paymentRegisterVO.getPaymentContractFlag()).getName());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", paymentRegisterVOList);
        ExcelExport.getInstance().export("paymentRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"paymentRegister-import.xlsx", (String)"\u4ed8\u6b3e\u767b\u8bb0\u5355-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @GetMapping(value={"/queryPaymentRegisterByContractId"})
    @ResponseBody
    public CommonResponse<List<PaymentRegisterVO>> queryPaymentRegisterByContractId(@RequestParam Long contractId) {
        List<PaymentRegisterEntity> paymentRegisterEntityList = this.service.queryPaymentRegisterByContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.mapList(paymentRegisterEntityList, PaymentRegisterVO.class));
    }

    @GetMapping(value={"/queryAlreadyPayMny"})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryAlreadyPayMny(@RequestParam Long contractId) {
        Map<String, BigDecimal> alreadyPayMnyMap = this.service.queryAlreadyPayMny(contractId);
        return CommonResponse.success(alreadyPayMnyMap);
    }

    @PostMapping(value={"/getTotalPaidMny"})
    @ResponseBody
    public CommonResponse<BigDecimal> getTotalPaidMny(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getTotalPaidMny(param));
    }
}

