package com.ejianc.business.weigh.weighbill.vo;

import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 
 * @author generator
 * 
 */
@ApiModel("推送数据-发货单主表")
public class DeliveryThirdVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("来源发货单主键")
    private Long sourceId;
    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("订单单据编号")
    private String orderBillCode;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("项目同步编码")
    private String syncCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    private Long customerId; // 甲方Id
    private String customerName; // 甲方名称
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    private String orderAddress; // 送货地址
    @ApiModelProperty("送货人名称")
    private String deliverName;
    @ApiModelProperty("送货人联系电话")
    private String deliverPhone;
    @ApiModelProperty("预计到货日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("是否关闭，0-否，1-是")
    private Integer closeFlag;
    @ApiModelProperty("验收状态，0-待接收,1-部分接收,2-全部接收")
    private Integer checkStatus;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("发货类型，CL-材料，HNT-混凝土")
    private String deliverType;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("使用部位")
    private String construction;

    @ApiModelProperty("子表")
    private List<DeliveryDetailThirdVO> detailList = new ArrayList<>();

    public String getSyncCode() {
        return syncCode;
    }

    public void setSyncCode(String syncCode) {
        this.syncCode = syncCode;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getOrderAddress() {
        return orderAddress;
    }

    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }

    /**
     * 来源发货单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源发货单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单单据编号
     */
    public String getOrderBillCode() {
        return orderBillCode;
    }

    /**
     * 订单单据编号
     */
    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人名称
     */
    public String getDeliverName() {
        return deliverName;
    }

    /**
     * 送货人名称
     */
    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    /**
     * 送货人联系电话
     */
    public String getDeliverPhone() {
        return deliverPhone;
    }

    /**
     * 送货人联系电话
     */
    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    /**
     * 预计到货日期
     */
    public Date getArriveDate() {
        return arriveDate;
    }

    /**
     * 预计到货日期
     */
    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 是否关闭，0-否，1-是
     */
    public Integer getCloseFlag() {
        return closeFlag;
    }

    /**
     * 是否关闭，0-否，1-是
     */
    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getDeliverType() {
        return deliverType;
    }

    public void setDeliverType(String deliverType) {
        this.deliverType = deliverType;
    }

    public List<DeliveryDetailThirdVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DeliveryDetailThirdVO> detailList) {
        this.detailList = detailList;
    }
}
