package com.ejianc.business.weigh.wagon.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.weigh.wagon.bean.WagonMaterialEntity;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;

/**
 * 称重材料设置
 *
 * @author generator
 */
@Controller
@RequestMapping("wagonMaterial")
@Api(value = "称重材料设置", tags = {"称重材料设置"})
public class WagonMaterialController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWagonMaterialService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WagonMaterialVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody WagonMaterialVO saveOrUpdateVO) {
        WagonMaterialEntity entity = BeanMapper.map(saveOrUpdateVO, WagonMaterialEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam
                    .build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        WagonMaterialVO vo = BeanMapper.map(entity, WagonMaterialVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WagonMaterialVO> queryDetail(@RequestParam Long id) {
        WagonMaterialEntity entity = service.selectById(id);
        WagonMaterialVO vo = BeanMapper.map(entity, WagonMaterialVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WagonMaterialVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WagonMaterialVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WagonMaterialVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WagonMaterialVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("orgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("isMyOrg") && "true".equals(param.getParams().get("isMyOrg").getValue().toString())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        }
        else {
            // 查询本身数据
            CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
            if (!parentOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> parentOrgIds = parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, parentOrgIds));
        }
        param.getParams().remove("isMyOrg");

        IPage<WagonMaterialEntity> page = service.queryPage(param, false);
        IPage<WagonMaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WagonMaterialVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<WagonMaterialEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WagonMaterial-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refWagonMaterialData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WagonMaterialVO>> refWagonMaterialData(@RequestParam Integer pageNumber,
                                                                       @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WagonMaterialEntity> page = service.queryPage(param, false);
        IPage<WagonMaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WagonMaterialVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("批量插入数据")
    @RequestMapping(value = "/insertBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Object>> insertBatch(@RequestBody List<WagonMaterialVO> vos) {
        return CommonResponse.success("批量处理成功！", service.insertBatch(vos));
    }

    @ApiOperation("修改状态")
    @RequestMapping(value = "/updateAutomaticWeigh", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateAutomaticWeigh(@RequestBody WagonMaterialVO saveOrUpdateVO) {
        service.updateAutomaticWeigh(saveOrUpdateVO);
        return CommonResponse.success("修改状态成功");
    }

    @ApiOperation("批量设置开启状态及换算系数")
    @RequestMapping(value = "/updateAutomaticWeighBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Object>> updateAutomaticWeighBatch(@RequestBody List<WagonMaterialVO> vos) {
        return CommonResponse.success("批量处理成功！", service.updateAutomaticWeighBatch(vos));
    }
}
