package com.ejianc.business.weigh.wagon.service;

import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.weigh.wagon.bean.WagonMaterialEntity;

import java.util.List;
import java.util.Map;

/**
 * 称重材料设置
 *
 * @author generator
 */
public interface IWagonMaterialService extends IBaseService<WagonMaterialEntity> {

    /**
     * 批量查询材料称重设置
     *
     * @param voList 材料
     * @return 结果
     */
    Map<String, Object> insertBatch(List<WagonMaterialVO> voList);

    /**
     * 修改自动称重开关
     *
     * @param saveOrUpdateVO 修改信息
     */
    void updateAutomaticWeigh(WagonMaterialVO saveOrUpdateVO);

    /**
     * 批量设置开启状态及换算系数
     *
     * @param voList 材料列表
     * @return 设置结果
     */
    Map<String, Object> updateAutomaticWeighBatch(List<WagonMaterialVO> voList);

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId  项目id
     * @param materialId 材料id
     * @return 查询结果，如果未设置，返回空对象
     */
    WagonMaterialVO queryMaterialAutomaticWeigh(Long projectId, Long materialId);

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId      项目id
     * @param materialIdList 材料id列表
     * @return 查询结果，如果未设置，返回空对象
     */
    List<WagonMaterialVO> queryMaterialAutomaticWeighBatch(Long projectId, List<Long> materialIdList);
}
