package com.ejianc.business.weigh.weighbill.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.wagon.bean.WagonIntegrateEntity;
import com.ejianc.business.weigh.wagon.bean.WagonProjectEntity;
import com.ejianc.business.weigh.wagon.service.IWagonIntegrateService;
import com.ejianc.business.weigh.wagon.service.IWagonProjectService;
import com.ejianc.business.weigh.weighbill.service.IPushDataToThirdService;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/weigh/")
public class PushThirdDataApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWagonProjectService wagonProjectService;

    @Autowired
    private IWagonIntegrateService wagonIntegrateService;

    /**
     * 根据物资明细id 获取发货单详情
     *
     * @param
     * @return
     */
    @ApiOperation("根据发货单推送数据到广联达平台")
    @RequestMapping(value = "/pushThirdData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> pushThirdData(@RequestBody DeliveryThirdVO deliveryThirdVO) {
        logger.info("推送数据参数参数：{}", JSONObject.toJSONString(deliveryThirdVO));
        //根据项目获取地磅信息
        List<WagonProjectEntity> list = wagonProjectService.list(new QueryWrapper<WagonProjectEntity>().eq("project_id",deliveryThirdVO.getProjectId()).eq("start_flag",0));
        if(CollectionUtils.isNotEmpty(list)){
            logger.info("根据项目查询地磅信息数据返回结果：{}", JSONObject.toJSONString(list));
            WagonProjectEntity wagonProjectEntity = list.get(0);
            deliveryThirdVO.setSyncCode(wagonProjectEntity.getWagonTypeCode());
            logger.info("查询项目编码：{}",deliveryThirdVO.getSyncCode());
            WagonIntegrateEntity wagonIntegrateEntity = wagonIntegrateService.getById(wagonProjectEntity.getWagonId());
            logger.info("查询实现类：{}",wagonIntegrateEntity.getRealizationClass());
            IPushDataToThirdService pushDataToGLDService = ContextUtil.getBean(wagonIntegrateEntity.getRealizationClass(), IPushDataToThirdService.class);
            CommonResponse<String> GldRes = pushDataToGLDService.pushDataToThird(deliveryThirdVO);
            if(!GldRes.isSuccess()){
                return CommonResponse.error(GldRes.getMsg());
            }
        }else{
            return CommonResponse.error("该项目未配置称重设置,请检查");
        }
        return CommonResponse.success("推送成功");
    }

}
