package com.ejianc.business.weigh.weighbill.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CheckStatusEnum {

    未验收(0, "未验收"),
    已验收(1, "已验收");



    private Integer code;
    private String description;
    private static Map<Integer, CheckStatusEnum> enumMap = new HashMap<>();

    CheckStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(CheckStatusEnum.class).stream().collect(Collectors.toMap(CheckStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static CheckStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
