package com.ejianc.business.weigh.wagon.service.impl;

import com.ejianc.business.weigh.wagon.vo.WagonProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.weigh.wagon.mapper.WagonProjectMapper;
import com.ejianc.business.weigh.wagon.bean.WagonProjectEntity;
import com.ejianc.business.weigh.wagon.service.IWagonProjectService;

import java.util.List;

/**
 * 称重项目设置
 *
 * @author generator
 */
@Service("wagonProjectService")
public class WagonProjectServiceImpl extends BaseServiceImpl<WagonProjectMapper, WagonProjectEntity> implements IWagonProjectService {

    /**
     * 修改启用停用标识
     *
     * @param vo 修改信息
     */
    @Override
    public void updateStartFlag(WagonProjectVO vo) {
        WagonProjectEntity entity = super.selectById(vo.getId());
        entity.setStartFlag(vo.getStartFlag());
        super.saveOrUpdate(entity, false);
    }

    /**
     * 新增或修改单据
     *
     * @param saveOrUpdateVO 单据信息
     * @return 新增结果
     */
    @Override
    public WagonProjectVO saveWagonProjectVO(WagonProjectVO saveOrUpdateVO) {
        QueryParam queryParam = new QueryParam();
        // 每个项目可以设置一个地磅；
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
//        queryParam.getParams().put("wagonId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getWagonId()));
        WagonProjectEntity entity;
        // 如果存在id则为修改，页面传入参数数据不全，需要查询按需修改
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0) {
            entity = BeanMapper.map(saveOrUpdateVO, WagonProjectEntity.class);
        }
        else {
            // 修改排除当前id
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
            entity = super.selectById(saveOrUpdateVO.getId());
            entity.setProjectId(saveOrUpdateVO.getProjectId());
            entity.setProjectName(saveOrUpdateVO.getProjectName());
            entity.setProjectCode(saveOrUpdateVO.getProjectCode());
            entity.setOrgId(saveOrUpdateVO.getOrgId());
            entity.setOrgName(saveOrUpdateVO.getOrgName());
            entity.setOrgCode(saveOrUpdateVO.getOrgCode());
            entity.setParentOrgId(saveOrUpdateVO.getParentOrgId());
            entity.setParentOrgName(saveOrUpdateVO.getParentOrgName());
            entity.setParentOrgCode(saveOrUpdateVO.getParentOrgCode());
            entity.setWagonId(saveOrUpdateVO.getWagonId());
            entity.setWagonName(saveOrUpdateVO.getWagonName());
            entity.setWagonCode(saveOrUpdateVO.getWagonCode());
            entity.setWagonTypeCode(saveOrUpdateVO.getWagonTypeCode());
            entity.setStartFlag(saveOrUpdateVO.getStartFlag());
        }
        List<WagonProjectEntity> checkList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(checkList)) {
            throw new BusinessException("该项目已设置称重信息，请勿重复添加");
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, WagonProjectVO.class);
    }
}
