package com.ejianc.business.wpsofficeedit.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 单据编辑信息实体
 *
 * @author CJ
 * @Description:
 * @date 2022/6/1 10:17
 */
@TableName(value = "ejc_wpsofficeedit_billeditinfo")
public class BillEditInfoEntity extends BaseEntity {
    private static final long serialVersionUID = -5980312263239536685L;

    /**
     * 单据Id，与Id保持一致
     */
    @TableField(value = "source_id")
    private Long sourceId;

    /**
     * 单据编辑类型：合同模板、合同文件等
     */
    @TableField(value = "bill_edit_type")
    private String billEditType;

    /**
     * 文件对应二维码
     */
    @TableField(value = "qr_code_base64")
    private String qRCodeBase64;

    /**
     * 单据类型编码
     */
    @TableField(value = "bill_type")
    private String billType;

    /**
     * 所属分类Id
     */
    @TableField(value = "category_id")
    private Long categoryId;

    /**
     * 对应模板Id
     */
    @TableField(value = "template_id")
    private Long templateId;

    /**
     * 对应文件Id
     */
    @TableField(value = "file_id")
    private Long fileId;

    /**
     * 文件名称
     */
    @TableField(value = "file_name")
    private String fileName;

    /**
     * 文件路径
     */
    @TableField(value = "file_path")
    private String filePath;

    /**
     * 文件大小
     */
    @TableField(value = "file_size")
    private Long fileSize;

    /**
     * 文件保存时是否替换原有文件
     */
    @TableField(value = "file_replace")
    private Boolean fileReplace;

    /**
     * 扩展字段1
     */
    @TableField(value = "extra_param1")
    private String extraParam1;

    /**
     * 扩展字段2
     */
    @TableField(value = "extra_param2")
    private String extraParam2;

    /**
     * 扩展字段3
     */
    @TableField(value = "extra_param3")
    private String extraParam3;

    /**
     * 扩展字段4
     */
    @TableField(value = "extra_param4")
    private Long extraParam4;

    /**
     * 扩展字段5
     */
    @TableField(value = "extra_param5")
    private Long extraParam5;

    /**
     * 扩展字段6
     */
    @TableField(value = "extra_param6")
    private Long extraParam6;

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getBillEditType() {
        return billEditType;
    }

    public void setBillEditType(String billEditType) {
        this.billEditType = billEditType;
    }

    public String getqRCodeBase64() {
        return qRCodeBase64;
    }

    public void setqRCodeBase64(String qRCodeBase64) {
        this.qRCodeBase64 = qRCodeBase64;
    }

    public String getExtraParam1() {
        return extraParam1;
    }

    public void setExtraParam1(String extraParam1) {
        this.extraParam1 = extraParam1;
    }

    public String getExtraParam2() {
        return extraParam2;
    }

    public void setExtraParam2(String extraParam2) {
        this.extraParam2 = extraParam2;
    }

    public String getExtraParam3() {
        return extraParam3;
    }

    public void setExtraParam3(String extraParam3) {
        this.extraParam3 = extraParam3;
    }

    public Long getExtraParam4() {
        return extraParam4;
    }

    public void setExtraParam4(Long extraParam4) {
        this.extraParam4 = extraParam4;
    }

    public Long getExtraParam5() {
        return extraParam5;
    }

    public void setExtraParam5(Long extraParam5) {
        this.extraParam5 = extraParam5;
    }

    public Long getExtraParam6() {
        return extraParam6;
    }

    public void setExtraParam6(Long extraParam6) {
        this.extraParam6 = extraParam6;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Boolean getFileReplace() {
        return fileReplace;
    }

    public void setFileReplace(Boolean fileReplace) {
        this.fileReplace = fileReplace;
    }
}
