/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wpsofficeedit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.ejianc.business.contractbase.api.ITemplateApi;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.business.wpsofficeedit.bean.BillEditInfoEntity;
import com.ejianc.business.wpsofficeedit.constants.WpsReturnCodeEnum;
import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import feign.Response;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/wpscbk/solution/"})
public class WpsCbkController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ITemplateApi templateApi;
    @Autowired
    @Value(value="${wps.domain}")
    private String wpsDomain;
    @Value(value="${wps.appId}")
    private String wpsAppId;
    @Value(value="${wps.appKey}")
    private String wpsAppKey;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${fileDownloadHost:#{NULL}}")
    private String DOWNLOAD_HOST;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private CacheManager cacheManager;
    private final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private final String WPS_ONLINE_USER = "WPS_ONLINE_USER:";
    private final int TIME_OUT = 86400;
    @Autowired
    private IBillEditInfoService billEditInfoService;
    private final String templateBillTypeCode = "BT211109000000003";
    private final String templateFileSourceType = "template";

    @GetMapping(value={"getUserToken"})
    public CommonResponse<String> getUserToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String cacheKey = InvocationInfoProxy.getUserid() + "::wpsUT::" + sdf.format(new Date()) + "::wpsUT::" + Md5Crypt.md5Crypt((byte[])InvocationInfoProxy.getToken().getBytes());
        this.cacheManager.setex(cacheKey, (Serializable)((Object)InvocationInfoProxy.getToken()), 86400);
        return CommonResponse.success((String)"\u83b7\u53d6\u7528\u6237wpsToken\u6210\u529f", (Object)cacheKey);
    }

    @GetMapping(value={"getWpsUrl"})
    public CommonResponse<JSONObject> getWpsUrl(@RequestParam(value="categoryId", required=false) Long categoryId, @RequestParam(value="templateId", required=false) Long templateId, @RequestParam(value="billType") String billType, @RequestParam(value="sourceId", required=false) String sourceId, @RequestParam(value="sourceType", required=false, defaultValue="template") String sourceType) throws UnsupportedEncodingException {
        TemplateVO template = null;
        JSONObject resp = new JSONObject();
        String wpsFileId = null;
        String replaceFile = "true";
        if (null == categoryId && null == templateId && "template".equals(sourceType)) {
            return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25\uff0c\u6a21\u677f\u53c2\u6570categoryId/templateId\u4e3a\u7a7a");
        }
        String authority = this.checkOnLine(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        CommonResponse tempResp = null;
        if (null == templateId) {
            tempResp = this.templateApi.getByCategoryId(categoryId);
            if (StringUtils.isBlank((String)sourceId)) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25\uff0c\u53c2\u6570sourceId\u4e3a\u7a7a");
            }
            if (!tempResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u53c2\u6570: templateId-{}, categoryId-{}[templateId\u4f18\u5148\u7ea7\u9ad8\u4e8ecategoryId]\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{templateId, categoryId, tempResp.getMsg()});
                return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\uff01");
            }
        } else {
            tempResp = this.templateApi.queryDetailById(templateId);
            if (StringUtils.isBlank((String)sourceId)) {
                sourceId = templateId.toString();
            }
        }
        template = (TemplateVO)tempResp.getData();
        if (null == categoryId) {
            categoryId = template.getCategoryId();
        }
        if ("template".equals(sourceType)) {
            wpsFileId = template.getId().toString();
        } else {
            BillEditInfoEntity billEdit = null;
            CommonResponse fileQueryResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, "desc");
            if (!fileQueryResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636esourceId-{},sourceType-{},billType-{}\u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{sourceId, billType, sourceType, fileQueryResp.getMsg()});
                return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)fileQueryResp.getData()))) {
                AttachmentVO file = (AttachmentVO)((List)fileQueryResp.getData()).get(0);
                wpsFileId = file.getId().toString();
                billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById((Serializable)((Object)sourceId)));
                if (null == billEdit) {
                    billEdit = this.billEditInfoService.generateNewBillEditInfo(sourceId, billType, sourceType, categoryId, wpsFileId, file.getFileName(), file.getFilePath(), file.getFileSize(), Boolean.valueOf(replaceFile), template.getId());
                } else if (null == billEdit.getFileId() || !billEdit.getFileId().equals(wpsFileId)) {
                    billEdit = this.billEditInfoService.updateBillEditInfo(sourceId, billType, sourceType, categoryId, wpsFileId, file.getFileName(), file.getFilePath(), file.getFileSize(), Boolean.valueOf(replaceFile), template.getId());
                }
            } else {
                CommonResponse fileCopyResp = this.attachmentApi.copyFile(template.getFileId().toString(), sourceId, billType, sourceType, true);
                if (!fileCopyResp.isSuccess()) {
                    this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25: {}", (Object)fileCopyResp.getMsg());
                    return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
                }
                AttachmentVO file = (AttachmentVO)fileCopyResp.getData();
                wpsFileId = file.getId().toString();
                billEdit = this.billEditInfoService.generateNewBillEditInfo(sourceId, billType, sourceType, categoryId, wpsFileId, file.getFileName(), file.getFilePath(), file.getFileSize(), Boolean.valueOf(replaceFile), template.getId());
            }
            resp.put("curQRBase64", (Object)billEdit.getqRCodeBase64());
        }
        Long tmplId = template.getId();
        BillEditInfoEntity billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(tmplId));
        if (null == billEdit) {
            billEdit = this.billEditInfoService.generateNewBillEditInfo(tmplId.toString(), billType, "template", categoryId, template.getFileId().toString(), template.getFileName(), template.getFilePath(), template.getFileSize(), Boolean.valueOf(replaceFile), template.getId());
        } else if (null == billEdit.getFileId() || !billEdit.getFileId().equals(template.getFileId())) {
            billEdit = this.billEditInfoService.updateBillEditInfo(tmplId.toString(), billType, "template", categoryId, template.getFileId().toString(), template.getFileName(), template.getFilePath(), template.getFileSize(), Boolean.valueOf(replaceFile), template.getId());
        }
        resp.put("templQRBase64", (Object)(null != billEdit ? billEdit.getqRCodeBase64() : null));
        if ("template".equals(sourceType)) {
            resp.put("curQRBase64", (Object)resp.getString("templQRBase64"));
        }
        resp.put("appId", (Object)this.wpsAppId);
        resp.put("fileId", (Object)wpsFileId);
        resp.put("token", this.getUserToken().getData());
        resp.put("metadata", (Object)template.getMetadata());
        resp.put("templateId", (Object)tmplId);
        resp.put("templateInfo", (Object)template);
        resp.put("billId", "template".equals(sourceType) ? tmplId : sourceId);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}"}, produces={"application/json;charset=UTF-8"})
    public Object getFileInfo(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        BillEditInfoEntity billEdit = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEdit) {
            billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        CommonResponse attachResp = this.attachmentApi.queryDetail(billEdit.getFileId().toString());
        if (!attachResp.isSuccess()) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u6839\u636e\u6587\u4ef6Id\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject resp = new JSONObject();
        resp.put("data", (Object)this.generateFileInfo((AttachmentVO)attachResp.getData(), "template".equals(billEdit.getBillEditType()) ? billEdit.getId().toString() : billEdit.getFileId().toString()));
        this.logger.info("\u6839\u636e\u6587\u4ef6Id\uff0c\u8fd4\u56deWPS\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/download"}, produces={"application/json;charset=UTF-8"})
    public Object getFileDownloadInfo(@PathVariable String fileId, HttpServletRequest req) throws Exception {
        return this.getFileVersionDownloadInfo(fileId, null, req);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/permission"}, produces={"application/json;charset=UTF-8"})
    public Object getUserPermission(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        Long userId = Long.valueOf(wpsToken.split("::wpsUT::")[0]);
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u67e5\u8be2\u7528\u6237\u6743\u9650\u4fe1\u606f\u6210\u529f!");
        JSONObject data = new JSONObject();
        data.put("user_id", (Object)userId.toString());
        data.put("read", (Object)1);
        data.put("update", (Object)1);
        data.put("download", (Object)1);
        data.put("rename", (Object)0);
        data.put("history", (Object)0);
        data.put("copy", (Object)1);
        data.put("print", (Object)1);
        data.put("saveas", (Object)0);
        data.put("comment", (Object)1);
        resp.put("data", (Object)data);
        this.logger.info("WPS \u7528\u6237\u6587\u4ef6\u6743\u9650\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    private JSONObject generateFileInfo(AttachmentVO file, String fileId) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("id", (Object)fileId);
        fileInfo.put("name", (Object)file.getFileName());
        fileInfo.put("version", (Object)file.getVersion());
        fileInfo.put("size", (Object)file.getFileSize());
        fileInfo.put("create_time", (Object)file.getCreateTime().getTime());
        fileInfo.put("modify_time", (Object)(null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime()));
        fileInfo.put("creator_id", (Object)file.getCreateUserCode());
        fileInfo.put("modifier_id", (Object)(null != file.getUpdateUserCode() ? file.getCreateUserCode() : file.getCreateUserCode()));
        this.changeUserCode2UserId(fileInfo);
        return fileInfo;
    }

    private void changeUserCode2UserId(JSONObject fileInfo) {
        HashSet<String> userCodes = new HashSet<String>();
        userCodes.add(fileInfo.getString("creator_id"));
        userCodes.add(fileInfo.getString("modifier_id"));
        if (!userCodes.isEmpty()) {
            CommonResponse userListResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userListResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u7528\u6237\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)userListResp));
            } else {
                List users = (List)userListResp.getData();
                if (!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    if (userCodeIdMap.containsKey(fileInfo.getString("creator_id"))) {
                        fileInfo.put("creator_id", (Object)userCodeIdMap.get(fileInfo.getString("creator_id")));
                    }
                    if (userCodeIdMap.containsKey(fileInfo.getString("modifier_id"))) {
                        fileInfo.put("modifier_id", (Object)userCodeIdMap.get(fileInfo.getString("modifier_id")));
                    }
                }
            }
        }
    }

    private JSONObject checkWpsToken(String wpsToken) {
        String userToken;
        if (StringUtils.isBlank((String)wpsToken)) {
            this.logger.info("wpsToke\u4e3a\u7a7a\uff0c\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "token\u4fe1\u606f\u4e3a\u7a7a\uff0c\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String userId = wpsToken.split("::wpsUT::")[0];
        String authority = this.checkOnLine(userId, userToken = (String)((Object)this.cacheManager.get(wpsToken)));
        if (null == authority) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u7528\u6237\u4f1a\u8bdd\u4fe1\u606f\u5931\u6548\uff01");
        }
        return this.getReturnMsg(WpsReturnCodeEnum.Success, "\u9a8c\u8bc1\u901a\u8fc7", authority);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions"}, produces={"application/json;charset=UTF-8"})
    public Object getFileHistory(@PathVariable String fileId, @RequestParam Integer offset, @RequestParam Integer limit, HttpServletRequest req) {
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        ArrayList<JSONObject> fileHistList = new ArrayList<JSONObject>();
        BillEditInfoEntity billEditInfo = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEditInfo) {
            billEditInfo = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        Long sourceId = billEditInfo.getSourceId();
        String sourceType = billEditInfo.getBillEditType();
        String billType = billEditInfo.getBillType();
        HashSet<String> userCodes = new HashSet<String>();
        switch (sourceType) {
            case "inviteFile": 
            case "contractFile": {
                CommonResponse attachResp = this.attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
                if (!attachResp.isSuccess()) {
                    this.logger.error("\u6839\u636etemplateId-{}, start-{}, size-{}\u67e5\u8be2\u6a21\u677f\u7248\u672c\u5217\u8868\u5931\u8d25\uff0c{}", new Object[]{sourceId, offset, limit, attachResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                List files = (List)attachResp.getData();
                if (!CollectionUtils.isNotEmpty((Collection)files)) break;
                AttachmentVO attachmentVO = (AttachmentVO)files.get(0);
                JSONObject tmp = new JSONObject();
                tmp.put("id", (Object)sourceId.toString());
                tmp.put("name", (Object)attachmentVO.getFileName());
                tmp.put("size", (Object)attachmentVO.getFileSize());
                tmp.put("version", (Object)attachmentVO.getVersion());
                tmp.put("create_time", (Object)attachmentVO.getCreateTime().getTime());
                tmp.put("modify_time", (Object)(null != attachmentVO.getUpdateTime() ? attachmentVO.getUpdateTime().getTime() : attachmentVO.getCreateTime().getTime()));
                tmp.put("creator_id", (Object)attachmentVO.getCreateUserCode());
                tmp.put("modifier_id", (Object)(null != attachmentVO.getUpdateUserCode() ? attachmentVO.getUpdateUserCode() : attachmentVO.getCreateUserCode()));
                userCodes.add(tmp.getString("creator_id"));
                userCodes.add(tmp.getString("modifier_id"));
                fileHistList.add(tmp);
                break;
            }
            default: {
                CommonResponse listResp = this.templateApi.getHisListByTemplateId(sourceId.toString(), offset.intValue(), limit.intValue());
                if (!listResp.isSuccess()) {
                    this.logger.error("\u6839\u636etemplateId-{}, start-{}, size-{}\u67e5\u8be2\u6a21\u677f\u7248\u672c\u5217\u8868\u5931\u8d25\uff0c{}", new Object[]{sourceId, offset, limit});
                    return this.getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                ((List)listResp.getData()).forEach(item -> {
                    JSONObject tmp = new JSONObject();
                    tmp.put("id", (Object)item.getFileId().toString());
                    tmp.put("name", (Object)item.getFileName());
                    tmp.put("size", (Object)item.getFileSize());
                    tmp.put("version", (Object)item.getTemplateVersion());
                    tmp.put("create_time", (Object)item.getCreateTime().getTime());
                    tmp.put("modify_time", (Object)(null != item.getUpdateTime() ? item.getUpdateTime().getTime() : item.getCreateTime().getTime()));
                    tmp.put("creator_id", (Object)item.getCreateUserCode());
                    tmp.put("modifier_id", (Object)(null != item.getUpdateUserCode() ? item.getUpdateUserCode() : item.getCreateUserCode()));
                    userCodes.add(tmp.getString("creator_id"));
                    userCodes.add(tmp.getString("modifier_id"));
                    fileHistList.add(tmp);
                });
            }
        }
        if (!userCodes.isEmpty()) {
            CommonResponse userListResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userListResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u7528\u6237\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)userListResp));
            } else {
                List users = (List)userListResp.getData();
                if (!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    fileHistList.stream().forEach(item -> {
                        if (userCodeIdMap.containsKey(item.getString("creator_id"))) {
                            item.put("creator_id", userCodeIdMap.get(item.getString("creator_id")));
                        }
                        if (userCodeIdMap.containsKey(item.getString("modifier_id"))) {
                            item.put("modifier_id", userCodeIdMap.get(item.getString("modifier_id")));
                        }
                    });
                }
            }
        }
        resp.put("data", fileHistList);
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions/{version}"}, produces={"application/json;charset=UTF-8"})
    public Object fileVersionInfo(@PathVariable String fileId, @PathVariable(value="version") Long version, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        JSONObject fileInfo = null;
        BillEditInfoEntity billEditInfo = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEditInfo) {
            billEditInfo = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        Long sourceId = billEditInfo.getSourceId();
        String sourceType = billEditInfo.getBillEditType();
        String billType = billEditInfo.getBillType();
        String categoryId = billEditInfo.getCategoryId().toString();
        String actualFileId = billEditInfo.getFileId().toString();
        switch (sourceType) {
            case "inviteFile": 
            case "contractFile": {
                fileInfo = this.getFile(sourceId.toString(), sourceType, billType, actualFileId, categoryId);
                break;
            }
            default: {
                fileInfo = this.getTmplFileInfo((long)sourceId, version, billType);
            }
        }
        if (!Boolean.valueOf(fileInfo.get((Object)"oprResult").toString()).booleanValue()) {
            fileInfo.remove((Object)"oprResult");
            return fileInfo;
        }
        fileInfo.remove((Object)"oprResult");
        fileInfo.put("id", (Object)fileId);
        this.changeUserCode2UserId(fileInfo);
        resp.put("data", (Object)fileInfo);
        this.logger.info("fileVersionInfo: {}", (Object)JSONObject.toJSONString((Object)resp));
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/users"}, produces={"application/json;charset=UTF-8"})
    public Object onLineUsersInfo(@RequestParam(value="user_ids") String[] userIds, HttpServletRequest req) {
        CommonResponse userResp;
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, null);
        JSONArray users = new JSONArray();
        if (null != userIds && userIds.length > 0) {
            userResp = this.userApi.queryListByIds(userIds);
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237Id-{}\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25, msg-{}", (Object)userIds, (Object)userResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
        } else {
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u53c2\u6570\u7528\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        ((List)userResp.getData()).stream().forEach(user -> {
            JSONObject userInfo = new JSONObject();
            userInfo.put("id", (Object)user.getId().toString());
            userInfo.put("name", (Object)user.getUserName());
            userInfo.put("avatar_url", (Object)(StringUtils.isNotBlank((String)user.getAvator()) ? user.getAvator() : ""));
            users.add((Object)userInfo);
        });
        resp.put("data", (Object)users);
        return resp.toString();
    }

    private String checkOnLine(String userId, String token) {
        this.logger.info("wpscbk check user session online: userId-{}, token-{}", (Object)userId, (Object)token);
        boolean isOnline = this.sessionManager.validateOnlineSession(userId, token);
        if (isOnline) {
            return this.getAuthority(userId, token);
        }
        this.logger.info("wpscbk check user session invalid: userId-{}, token-{}", (Object)userId, (Object)token);
        return null;
    }

    private String getAuthority(String userId, String token) {
        try {
            String sid = "ICOP_SESSION_USER:" + userId;
            String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, token);
            if (StringUtils.isNotBlank((String)userContextStr)) {
                UserContext userContext = (UserContext)JSONObject.parseObject((String)userContextStr, UserContext.class);
                this.logger.debug("wpscbk check user session online: userId-{}, token-{}, userContext-{}", new Object[]{userId, token, JSONObject.toJSONString((Object)userContext)});
                return "userType=" + userContext.getUserType() + ";userCode=" + URLEncoder.encode(userContext.getUserCode(), "UTF-8") + ";userName=" + URLEncoder.encode(userContext.getUserName(), "UTF-8") + ";orgId=" + userContext.getOrgId() + ";orgName=" + URLEncoder.encode(userContext.getOrgName(), "UTF-8") + ";tenantid=" + userContext.getTenantid() + ";token=" + userContext.getToken() + ";u_logints=" + userContext.getU_logints() + ";u_usercode=" + userContext.getU_usercode() + ";u_locale=" + userContext.getU_locale() + ";userId=" + userId;
            }
        }
        catch (Exception e) {
            this.logger.info("wpscbk check user session error: userId-{}, token-{}", new Object[]{userId, token, e});
            return null;
        }
        return null;
    }

    @PostMapping(value={"v3/3rd/files/{fileId}/upload"}, produces={"application/json;charset=UTF-8"})
    public Object saveFile(@PathVariable String fileId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="name") String originalFileNameStr, @RequestParam(value="size") Integer size, @RequestParam(value="manual", required=false) boolean isManual, @RequestParam(value="attachment_size", required=false) Integer attachmentSize, @RequestParam(value="content_type", required=false) String contentType, @RequestParam(value="sha1", required=false) String sha1, HttpServletRequest req) {
        this.logger.info("\u63a5\u6536\u5230\u6a21\u677f\u4fdd\u5b58\u8bf7\u6c42\uff1afileId-{}, size-{}, isManual-{}, originalFileNameStr-{}, attachmentSize-{}, contentType-{},sha1-{}", new Object[]{fileId, size, isManual, originalFileNameStr, attachmentSize, contentType, sha1});
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        JSONObject fileInfo = null;
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        BillEditInfoEntity billEditInfo = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEditInfo) {
            billEditInfo = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        String sourceId = billEditInfo.getSourceId().toString();
        String sourceType = billEditInfo.getBillEditType();
        String billType = billEditInfo.getBillType();
        Boolean replace = billEditInfo.getFileReplace();
        String templateId = billEditInfo.getTemplateId().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", sourceType);
        params.put("sourceId", sourceId);
        params.put("billType", billType);
        params.put("originalFileNameStr", StringUtils.isNotBlank((String)originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
        params.put("replace", replace.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", checkToken.getString("data"));
        AttachmentVO attachmentVO = null;
        try {
            String fileUploadRespStr;
            CommonResponse attachmentResp;
            if (!"template".equals(sourceType)) {
                String queryFileRespStr = HttpTookit.get((String)(this.BASE_HOST + "ejc-file-web/api/attachref/queryListBySourceId"), params, headers);
                CommonResponse queryFileResp = (CommonResponse)JSONObject.parseObject((String)queryFileRespStr, CommonResponse.class);
                if (!queryFileResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5f53\u524d\u5355\u636e\u7f16\u8f91\u6587\u4ef6\u4fe1\u606f\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, queryFileResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
                }
                String curBillFileId = queryFileResp.getData() != null ? ((AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)queryFileResp.getData()).get(0)), AttachmentVO.class)).getId().toString() : null;
                this.logger.info("\u5f53\u524d\u5f85\u4fdd\u5b58\u9644\u4ef6Id-{}\uff0c\u5408\u540c\u6587\u4ef6Id-{}", (Object)fileId, curBillFileId);
                if (CollectionUtils.isEmpty((Collection)((Collection)queryFileResp.getData())) || !fileId.equals(curBillFileId)) {
                    this.logger.info("\u5f53\u524d\u5f85\u6587\u4ef6\u4fe1\u606f\u4e0e\u5355\u636e\u7f16\u8f91\u6587\u4ef6\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\uff01");
                    return this.getReturnMsg(WpsReturnCodeEnum.Success, "\u670d\u52a1\u5904\u7406\u4e2d...").toString();
                }
            }
            if (!(attachmentResp = (CommonResponse)JSONObject.parseObject((String)(fileUploadRespStr = WpsCbkController.postFile(this.BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file)), CommonResponse.class)).isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, attachmentResp.getMsg()});
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
            }
            attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, e});
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
        }
        this.logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
        this.billEditInfoService.updateBillEditInfo(attachmentVO.getSourceId().toString(), null, null, null, attachmentVO.getId().toString(), attachmentVO.getFileName(), attachmentVO.getFilePath(), attachmentVO.getFileSize(), null, null);
        switch (sourceType) {
            case "inviteFile": 
            case "contractFile": {
                fileInfo = this.updateFileInfo(attachmentVO, billType, authority, Long.valueOf(templateId), attachmentVO.getId());
                break;
            }
            default: {
                fileInfo = this.newTemplateVersion(attachmentVO, sourceId, authority, billType);
            }
        }
        this.logger.info("\u6a21\u677f\u4fe1\u606f\u66f4\u65b0\u7ed3\u679c\uff1a{}", (Object)fileInfo);
        if (!Boolean.valueOf(fileInfo.get((Object)"oprResult").toString()).booleanValue()) {
            fileInfo.remove((Object)"oprResult");
            return fileInfo;
        }
        fileInfo.remove((Object)"oprResult");
        this.changeUserCode2UserId(fileInfo);
        resp.put("data", (Object)fileInfo);
        this.logger.info("\u6587\u4ef6\u4fdd\u5b58\u8fd4\u56de\u4fe1\u606f");
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions/{version}/download"}, produces={"application/json;charset=UTF-8"})
    public Object getFileVersionDownloadInfo(@PathVariable String fileId, @PathVariable String version, HttpServletRequest req) throws Exception {
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        BillEditInfoEntity billEditInfo = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEditInfo) {
            billEditInfo = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        String actualFileId = "template".equals(billEditInfo.getBillEditType()) ? billEditInfo.getSourceId().toString() : billEditInfo.getFileId().toString();
        JSONObject data = new JSONObject();
        data.put("url", (Object)((StringUtils.isNotBlank((String)this.DOWNLOAD_HOST) ? this.DOWNLOAD_HOST : this.BASE_HOST) + "ejc-wpsofficeedit-web/wpscbk/solution/downloadFileByTmpId?fileId=" + actualFileId + "&wpsten=" + URLEncoder.encode(wpsToken, "UTF-8")));
        resp.put("data", (Object)data);
        this.logger.info("\u8fd4\u56deWPS\u6587\u6863\u4e0b\u8f7d\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    @PostMapping(value={"resetContractFile"})
    public CommonResponse<AttachmentVO> resetContractFile(@RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="categoryId", required=false) String categoryId, @RequestParam(value="sourceId") String sourceId, @RequestParam(value="sourceType") String sourceType, @RequestParam(value="billType") String billType, HttpServletRequest request) {
        CommonResponse tempResp;
        if (null == templateId && null == categoryId) {
            return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u53c2\u6570templateId\u3001categoryId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        TemplateVO template = null;
        if (null != templateId) {
            tempResp = this.templateApi.queryDetailById(Long.valueOf(templateId));
            if (!tempResp.isSuccess()) {
                this.logger.error("\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25, \u4f9d\u636eid-{}\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25: {}", (Object)templateId, (Object)tempResp.getMsg());
                return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
            }
            template = (TemplateVO)tempResp.getData();
        } else {
            tempResp = this.templateApi.getByCategoryId(Long.valueOf(categoryId));
            if (!tempResp.isSuccess()) {
                this.logger.error("\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25, \u4f9d\u636ecategoryId-{}\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25: {}", (Object)categoryId, (Object)tempResp.getMsg());
                return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
            }
            template = (TemplateVO)tempResp.getData();
        }
        CommonResponse fileCopyResp = this.attachmentApi.copyFile(template.getFileId().toString(), sourceId, billType, sourceType, true);
        this.logger.error("\u6839\u636e\u4ece\u5408\u540c\u6a21\u677f\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6,\u53c2\u6570--->sourceFileId-{}, sourceId-{}, sourceType-{}, billType-{}, \u7ed3\u679c-->{}", new Object[]{template.getFileId().toString(), sourceId, sourceType, billType, JSONObject.toJSONString((Object)fileCopyResp)});
        if (!fileCopyResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25: {}", (Object)fileCopyResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
        }
        BillEditInfoEntity billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById((Serializable)((Object)sourceId)));
        if (null != billEdit) {
            billEdit.setqRCodeBase64(null);
            this.billEditInfoService.saveOrUpdate((Object)billEdit, false);
        }
        this.updateFileInfo((AttachmentVO)fileCopyResp.getData(), billType, request.getHeader("authority"), null, null);
        return CommonResponse.success((String)"\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u6210\u529f\uff01", (Object)fileCopyResp.getData());
    }

    @PostMapping(value={"updateSignFileInfo"})
    public CommonResponse<AttachmentVO> updateSignFileInfo(@RequestBody AttachmentVO attachmentVO) {
        String authority = this.getAuthority(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());
        if (StringUtils.isBlank((String)authority)) {
            this.logger.error("\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606ffileInfo-\u3010{}\u3011\u66f4\u65b0\u5931\u6557\uff0c\u83b7\u53d6Authority\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)attachmentVO));
            return CommonResponse.error((String)"\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u6557\uff0c\u83b7\u53d6Authority\u5931\u8d25\uff01");
        }
        JSONObject updateResult = this.updateFileInfo(attachmentVO, attachmentVO.getBillType(), authority, null, null);
        if (updateResult.getBoolean("oprResult").booleanValue()) {
            return CommonResponse.success((String)"\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)attachmentVO);
        }
        return CommonResponse.error((String)updateResult.getString("details"));
    }

    public JSONObject updateFileInfo(AttachmentVO attachmentVO, String billType, String authority, Long templateId, Long mainFileId) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", (Object)true);
        boolean mergeFlag = false;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("authority", authority);
        headerMap.put("content-type", "application/json;charset=UTF-8");
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            this.logger.error("\u9644\u4ef6\u66f4\u65b0\u5931\u8d25,\u6839\u636ebillType-{}\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u66f4\u65b0\u5931\u8d25\uff01");
        }
        MdReferVO mdRef = (MdReferVO)mdRefResp.getData();
        String entityNameFmt = mdRef.getEntityName().replace("Entity", "");
        String httpReqPrefix = this.BASE_HOST + mdRef.getProjectName() + "/" + entityNameFmt.substring(0, 1).toLowerCase() + entityNameFmt.substring(1);
        AttachmentVO wholeDataFile = null;
        if (null != templateId) {
            HashMap<String, Long> detailQueryParam = new HashMap<String, Long>();
            detailQueryParam.put("templateId", templateId);
            try {
                String detailExportListJson = HttpTookit.get((String)(this.BASE_HOST + "ejc-contractbase-web/api/templDetail/findExportDetailByCategoryId"), detailQueryParam, headerMap);
                this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)templateId, (Object)detailExportListJson);
                CommonResponse templDetailResp = (CommonResponse)JSONObject.parseObject((String)detailExportListJson, CommonResponse.class);
                if (!templDetailResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)templateId), (Object)templDetailResp.getMsg());
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
                }
                List detailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)templDetailResp.getData()), TemplDetailExportSettingVO.class);
                HashMap billData = new HashMap();
                HashMap<String, String> billDataQuery = new HashMap<String, String>();
                billDataQuery.put("id", attachmentVO.getSourceId().toString());
                String billDataQueryUrl = httpReqPrefix + "FileUpdate/getBillDataJson";
                String billDataQueryRespStr = HttpTookit.get((String)billDataQueryUrl, billDataQuery, headerMap);
                this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u8be6\u60c5\u7ed3\u679c\uff1a{}", new Object[]{billDataQueryUrl, JSONObject.toJSONString(billDataQuery), billDataQueryRespStr});
                CommonResponse billDataResp = (CommonResponse)JSONObject.parseObject((String)billDataQueryRespStr, CommonResponse.class);
                if (!billDataResp.isSuccess()) {
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5355\u636e\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff01");
                }
                JSONObject billDataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)billDataResp.getData()));
                ArrayList<Future<File>> backFileIdFutures = new ArrayList<Future<File>>(detailList.size());
                HashMap<String, Integer> sequence = new HashMap<String, Integer>();
                JSONArray billDataJsonArr = null;
                for (TemplDetailExportSettingVO templDetail : detailList) {
                    this.logger.info("\u5b50\u8868\u5bfc\u51fa\u8bbe\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)templDetail));
                    if (null == templDetail.getCustomFileId() && null == templDetail.getSysFileId()) continue;
                    billDataJsonArr = billDataJson.getJSONArray(templDetail.getMainAttrName());
                    if (!(null == templDetail.getEmptyExportFlag() || templDetail.getEmptyExportFlag().booleanValue() || null != billDataJsonArr && billDataJsonArr.size() != 0)) {
                        this.logger.info("\u5b50\u8868-[{}]\u8bbe\u7f6e\u6570\u636e\u4e3a\u7a7a\u65f6\u4e0d\u8fdb\u884c\u5bfc\u51fa\uff0c\u8df3\u8fc7\u8be5\u5b50\u8868\u5bfc\u51fa\u64cd\u4f5c\uff01", (Object)templDetail.getDetailName());
                        continue;
                    }
                    backFileIdFutures.add(this.getTemplDetailPdfFileId(templDetail, attachmentVO.getSourceId(), billDataJsonArr, authority, sequence));
                }
                File tempFile = null;
                HashMap filesMap = new HashMap();
                for (Future future : backFileIdFutures) {
                    HashMap<String, FileInputStream> fileMap = new HashMap<String, FileInputStream>();
                    tempFile = (File)future.get();
                    if (null == tempFile) {
                        this.logger.info("\u83b7\u53d6\u5b50\u8868\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5bfc\u51fa");
                        continue;
                    }
                    this.logger.info("\u83b7\u53d6\u5230\u5b50\u8868\u6587\u4ef6\uff1a{}", (Object)tempFile.getName());
                    fileMap.put(tempFile.getName(), new FileInputStream(tempFile));
                    filesMap.put(tempFile.getName(), fileMap);
                }
                if (MapUtils.isNotEmpty(filesMap)) {
                    HashMap<String, String> mergeParams = new HashMap<String, String>();
                    mergeParams.put("sourceId", attachmentVO.getSourceId().toString());
                    mergeParams.put("sourceType", "billWholeDataPdf");
                    mergeParams.put("billType", attachmentVO.getBillType());
                    mergeParams.put("mainFileId", attachmentVO.getId().toString());
                    mergeParams.put("replace", "true");
                    mergeParams.put("mergeSequence", JSONObject.toJSONString(sequence));
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("authority", authority);
                    String fileMergeResult = HttpTookit.postFiles((String)(this.BASE_HOST + "ejc-file-web/attachment/uploadAndMerge2Pdf"), mergeParams, hashMap, filesMap, (Integer)10000, (Integer)10000);
                    this.logger.info("\u6587\u4ef6\u5408\u5e76-\u3010\u53c2\u6570\uff1a{}\uff0cheader-{}, \u4e0a\u4f20\u6587\u4ef6\u6570\u91cf\uff1a{}\u3011\u7ed3\u679c\uff1a{}", new Object[]{JSONObject.toJSONString(mergeParams), JSONObject.toJSONString(hashMap), filesMap.keySet().size(), fileMergeResult});
                    CommonResponse wholeDataAttchResp = (CommonResponse)JSONObject.parseObject((String)fileMergeResult, CommonResponse.class);
                    if (!wholeDataAttchResp.isSuccess()) {
                        this.logger.error("\u751f\u6210\u5355\u636e\u5168\u6570\u636ePDF\u6587\u4ef6\u5931\u8d25\uff01");
                    }
                    wholeDataFile = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)wholeDataAttchResp.getData()), AttachmentVO.class);
                    mergeFlag = true;
                }
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u5f02\u5e38\uff1a", (Object)templateId, (Object)e);
            }
        }
        String url = httpReqPrefix + "FileUpdate/updateFileInfo";
        this.logger.info("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u9644\u4ef6\u4fe1\u606f\u5730\u5740\uff1a{}", (Object)url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (mergeFlag && wholeDataFile != null) {
            param.put("billId", wholeDataFile.getSourceId());
            param.put("sourceType", wholeDataFile.getSourceType());
            param.put("billType", billType);
            param.put("fileId", wholeDataFile.getId());
            param.put("fileSize", wholeDataFile.getFileSize());
            param.put("fileName", wholeDataFile.getFileName());
            param.put("fileOnlinePath", wholeDataFile.getOnlinePath());
            param.put("imgServerPath", wholeDataFile.getImgServerPath());
            param.put("formatPathStr", wholeDataFile.getFileFormatPathStr());
            param.put("fileVersion", wholeDataFile.getVersion());
        } else {
            param.put("billId", attachmentVO.getSourceId());
            param.put("sourceType", attachmentVO.getSourceType());
            param.put("billType", billType);
            param.put("fileId", attachmentVO.getId());
            param.put("fileSize", attachmentVO.getFileSize());
            param.put("fileName", attachmentVO.getFileName());
            param.put("fileOnlinePath", attachmentVO.getOnlinePath());
            param.put("imgServerPath", attachmentVO.getImgServerPath());
            param.put("formatPathStr", attachmentVO.getFileFormatPathStr());
            param.put("fileVersion", attachmentVO.getVersion());
        }
        try {
            String httpRespStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(param), headerMap, (Integer)10000, (Integer)10000);
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u66f4\u65b0\u5355\u636e\u6587\u6863\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString(param), httpRespStr});
            resp.put("id", (Object)attachmentVO.getId().toString());
            resp.put("name", (Object)attachmentVO.getFileName());
            resp.put("size", (Object)attachmentVO.getFileSize());
            resp.put("version", (Object)attachmentVO.getVersion());
            resp.put("create_time", (Object)attachmentVO.getCreateTime().getTime());
            resp.put("modify_time", (Object)(null != attachmentVO.getUpdateTime() ? attachmentVO.getUpdateTime().getTime() : attachmentVO.getCreateTime().getTime()));
            resp.put("creator_id", (Object)attachmentVO.getCreateUserCode());
            resp.put("modifier_id", (Object)(null != attachmentVO.getUpdateUserCode() ? attachmentVO.getUpdateUserCode() : attachmentVO.getCreateUserCode()));
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u66f4\u65b0\u5355\u636e\u6587\u6863\u4fe1\u606f\u5f02\u5e38\uff1a", new Object[]{url, JSONObject.toJSONString(param), e});
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="commonTask")
    public Future<File> getTemplDetailPdfFileId(TemplDetailExportSettingVO templDetail, Long sourceId, JSONArray billData, String authority, Map<String, Integer> sequence) throws Exception {
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        dataMap.put(templDetail.getMainAttrName(), null == billData || billData.size() == 0 ? new ArrayList() : billData);
        this.logger.info("\u5c06\u6570\u636e{}\u5199\u5165\u5b50\u8868\uff1a{}", (Object)JSONObject.toJSONString(dataMap), (Object)templDetail.getMainAttrName());
        File dataFile = File.createTempFile(templDetail.getBelongEntityId().toString(), ".xlsx");
        sequence.put(dataFile.getName(), null != templDetail.getDetailSequence() ? templDetail.getDetailSequence() : 0);
        FileOutputStream dataOuts = new FileOutputStream(dataFile);
        XLSTransformer transformer = new XLSTransformer();
        Workbook workbook = null;
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(null != templDetail.getCustomFileId() ? templDetail.getCustomFileId() : templDetail.getSysFileId());
            Response.Body body = fileResponse.body();
            InputStream inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            workbook = transformer.transformXLS((InputStream)bufferedInputStream, dataMap);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setWrapText(true);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.setAutobreaks(true);
            WpsCbkController.autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum(), cellStyle);
            workbook.write((OutputStream)dataOuts);
        }
        catch (Exception e) {
            this.logger.error("\u5b50\u8868-\u3010{}\u3011\u6570\u636e\u5199\u5165\u5bfc\u51fa\u6a21\u677f\u5f02\u5e38:", (Throwable)e);
            AsyncResult asyncResult = new AsyncResult(null);
            return asyncResult;
        }
        finally {
            if (null != workbook) {
                workbook.close();
            }
            if (null != dataOuts) {
                dataOuts.flush();
            }
            if (null != dataOuts) {
                ((OutputStream)dataOuts).close();
            }
        }
        return new AsyncResult((Object)dataFile);
    }

    private JSONObject newTemplateVersion(AttachmentVO attachmentVO, String sourceId, String authority, String billType) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", (Object)true);
        CommonResponse tmplVersionResp = this.templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
        if (!tmplVersionResp.isSuccess()) {
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateVersionVO template = (TemplateVersionVO)tmplVersionResp.getData();
        this.logger.info("\u83b7\u53d6\u5230\u5f53\u524d\u6700\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f: {}", (Object)JSONObject.toJSONString((Object)template));
        TemplateVersionVO newTmplVersion = this.generateNewTemplateVersion(template, attachmentVO);
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("authority", authority);
            header.put("content-type", "application/json;charset=UTF-8");
            String newTmplVersionRespStr = HttpTookit.postByJson((String)(this.BASE_HOST + "ejc-contractbase-web/api/template/createNewTmplVersion"), (String)JSONObject.toJSONString((Object)newTmplVersion), header, (Integer)10000, (Integer)1000);
            CommonResponse newTmplVersionResp = (CommonResponse)JSONObject.parseObject((String)newTmplVersionRespStr, CommonResponse.class);
            if (!newTmplVersionResp.isSuccess()) {
                this.logger.error("\u8c03\u7528\u6a21\u677f\u670d\u52a1\u66f4\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f-{}\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)newTmplVersion), (Object)newTmplVersionResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6a21\u677f\u670d\u52a1\u66f4\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f-{}\u5f02\u5e38\uff1a", (Object)JSONObject.toJSONString((Object)newTmplVersion), (Object)e);
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        resp.put("id", (Object)newTmplVersion.getFileId().toString());
        resp.put("name", (Object)newTmplVersion.getFileName());
        resp.put("size", (Object)newTmplVersion.getFileSize());
        resp.put("version", (Object)newTmplVersion.getTemplateVersion());
        resp.put("create_time", (Object)attachmentVO.getCreateTime().getTime());
        resp.put("modify_time", (Object)(null != attachmentVO.getUpdateTime() ? attachmentVO.getUpdateTime().getTime() : attachmentVO.getCreateTime().getTime()));
        resp.put("creator_id", (Object)attachmentVO.getCreateUserCode());
        resp.put("modifier_id", (Object)(null != attachmentVO.getUpdateUserCode() ? attachmentVO.getUpdateUserCode() : attachmentVO.getCreateUserCode()));
        return resp;
    }

    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)backState.getCode());
        resp.put("message", (Object)backState.getMessage());
        resp.put("details", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("hint", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("oprResult", (Object)false);
        return resp;
    }

    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg, Object data) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)backState.getCode());
        resp.put("message", (Object)backState.getMessage());
        resp.put("details", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("hint", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("oprResult", (Object)false);
        resp.put("data", data);
        return resp;
    }

    @GetMapping(value={"downloadFileByTmpId"})
    public void downloadFileByTmpId(@RequestParam(value="fileId") String fileId, @RequestParam(value="wpsten") String wpsten, HttpServletResponse response) throws Exception {
        String actualFileId;
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6\u53c2\u6570\uff1afileId-{},wpsten-{}", (Object)fileId, (Object)wpsten);
        String wpsToken = URLDecoder.decode(wpsten, "UTF-8");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            throw new BusinessException(checkToken.get((Object)"message").toString());
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        BillEditInfoEntity billEditInfo = this.billEditInfoService.getByFileId(Long.valueOf(fileId));
        if (null == billEditInfo) {
            billEditInfo = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(Long.valueOf(fileId)));
        }
        String sourceId = billEditInfo.getSourceId().toString();
        String sourceType = billEditInfo.getBillEditType();
        String billType = billEditInfo.getBillType();
        Boolean replace = billEditInfo.getFileReplace();
        String templateId = billEditInfo.getTemplateId().toString();
        String string = actualFileId = null != billEditInfo.getFileId() ? billEditInfo.getFileId().toString() : null;
        if (null == authority) {
            throw new BusinessException("\u7528\u6237\u4f1a\u8bdd\u5931\u6548\uff01");
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        Long attachId = null;
        if (StringUtils.isNotBlank((String)actualFileId)) {
            attachId = Long.valueOf(actualFileId);
        } else {
            switch (sourceType) {
                case "inviteFile": 
                case "contractFile": {
                    CommonResponse attachResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
                    if (!attachResp.isSuccess()) {
                        this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, attachResp.getMsg()});
                        throw new BusinessException("\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    if (CollectionUtils.isEmpty((Collection)((Collection)attachResp.getData()))) {
                        this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u627e\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f", new Object[]{sourceId, billType, sourceType});
                        throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
                    }
                    attachId = ((AttachmentVO)((List)attachResp.getData()).get(0)).getId();
                    break;
                }
                default: {
                    CommonResponse tmplVersionResp = this.templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
                    if (!tmplVersionResp.isSuccess()) {
                        this.logger.error("\u83b7\u53d6templateId-{}\u5bf9\u5e94\u6587\u4ef6\u5931\u8d25\uff01", (Object)sourceId, (Object)tmplVersionResp.getMsg());
                        throw new BusinessException("\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
                    }
                    attachId = ((TemplateVersionVO)tmplVersionResp.getData()).getFileId();
                }
            }
        }
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6fileId-{} ", (Object)attachId);
        InputStream inputStream = null;
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(attachId);
            Response.Body body = fileResponse.body();
            inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            response.setHeader("Content-Disposition", ((Collection)fileResponse.headers().get("Content-Disposition")).toString().replace("[", "").replace("]", ""));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int length = 0;
            byte[] temp = new byte[10240];
            while ((length = bufferedInputStream.read(temp)) != -1) {
                bufferedOutputStream.write(temp, 0, length);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TemplateVersionVO generateNewTemplateVersion(TemplateVersionVO tmplVersion, AttachmentVO attachmentVO) {
        TemplateVersionVO newTmplVersion = new TemplateVersionVO();
        newTmplVersion.setFileId(attachmentVO.getId());
        newTmplVersion.setFileName(attachmentVO.getFileName());
        newTmplVersion.setFilePath(attachmentVO.getFilePath());
        newTmplVersion.setFileSize(attachmentVO.getFileSize());
        newTmplVersion.setFileType(this.getFileType(attachmentVO.getFileName()));
        newTmplVersion.setSequence(tmplVersion.getSequence());
        newTmplVersion.setOnlinePath(attachmentVO.getOnlinePath());
        newTmplVersion.setTemplateName(tmplVersion.getTemplateName());
        newTmplVersion.setTemplateVersion(Long.valueOf(tmplVersion.getTemplateVersion() + 1L));
        newTmplVersion.setTenantId(tmplVersion.getTenantId());
        newTmplVersion.setTemplateId(tmplVersion.getTemplateId());
        return newTmplVersion;
    }

    private JSONObject getFile(String sourceId, String sourceType, String billType, String fileId, String categoryId) {
        CommonResponse userResp;
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("oprResult", (Object)true);
        AttachmentVO file = null;
        if (StringUtils.isNotBlank((String)fileId)) {
            CommonResponse attachmentResp = this.attachmentApi.queryDetail(fileId);
            if (!attachmentResp.isSuccess()) {
                this.logger.error("\u6839\u636eId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)fileId, (Object)attachmentResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6839\u636eId\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            file = (AttachmentVO)attachmentResp.getData();
        } else {
            CommonResponse attachResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, attachResp.getMsg()});
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)attachResp.getData()))) {
                this.logger.info("\u6839\u636esourceId-{},billType-{},sourceType-{}\u627e\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f, \u7ee7\u7eed\u6839\u636ecategoryId-{}\u67e5\u627e\u6587\u4ef6\u4fe1\u606f", new Object[]{sourceId, billType, sourceType, categoryId});
                CommonResponse tmplResp = this.templateApi.getByCategoryId(Long.valueOf(categoryId));
                if (!tmplResp.isSuccess()) {
                    this.logger.error("\u6839\u636ecategoryId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, tmplResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                }
                TemplateVO tmpl = (TemplateVO)tmplResp.getData();
                file = new AttachmentVO();
                file.setId(tmpl.getFileId());
                file.setFileName(tmpl.getFileName());
                file.setFileSize(tmpl.getFileSize());
                file.setVersion(Integer.valueOf(1));
                file.setCreateUserCode(tmpl.getCreateUserCode());
                file.setUpdateUserCode(tmpl.getUpdateUserCode());
            } else {
                file = (AttachmentVO)((List)attachResp.getData()).get(0);
            }
        }
        ArrayList<String> userCodeList = new ArrayList<String>();
        userCodeList.add(file.getCreateUserCode());
        if (null != file.getUpdateUserCode() && !userCodeList.contains(file.getUpdateUserCode())) {
            userCodeList.add(file.getUpdateUserCode());
        }
        if (!(userResp = this.userApi.queryUserByUserCodes(userCodeList.toArray(new String[userCodeList.size()]))).isSuccess()) {
            this.logger.error("\u6839\u636e\u7528\u6237\u7f16\u7801\u5217\u8868-\u3010{}\u3011\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(userCodeList), (Object)JSONObject.toJSONString((Object)userResp));
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Map<String, UserVO> userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item));
        fileInfo.put("name", (Object)file.getFileName());
        fileInfo.put("version", (Object)file.getVersion());
        fileInfo.put("size", (Object)file.getFileSize());
        fileInfo.put("creator_id", (Object)file.getCreateUserCode());
        fileInfo.put("modifier_id", (Object)(null != file.getUpdateUserCode() ? file.getUpdateUserCode() : file.getCreateUserCode()));
        fileInfo.put("create_time", (Object)file.getCreateTime().getTime());
        fileInfo.put("modify_time", (Object)(null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime()));
        return fileInfo;
    }

    private JSONObject getTmplFileInfo(Long templateId, Long version, String billType) {
        CommonResponse versionResp = this.templateApi.getTemplateVersionInfo(templateId, version);
        JSONObject fileInfo = new JSONObject();
        if (!versionResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u53c2\u6570: templateId-{}\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)templateId, (Object)versionResp.getMsg());
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateVersionVO templateVersionVO = (TemplateVersionVO)versionResp.getData();
        fileInfo.put("name", (Object)templateVersionVO.getFileName());
        fileInfo.put("version", (Object)templateVersionVO.getTemplateVersion());
        fileInfo.put("size", (Object)templateVersionVO.getFileSize());
        fileInfo.put("create_time", (Object)templateVersionVO.getCreateUserCode());
        fileInfo.put("modifier_id", (Object)(null != templateVersionVO.getUpdateUserCode() ? templateVersionVO.getUpdateUserCode() : templateVersionVO.getCreateUserCode()));
        fileInfo.put("create_time", (Object)templateVersionVO.getCreateTime().getTime());
        fileInfo.put("modify_time", (Object)(null != templateVersionVO.getUpdateTime() ? templateVersionVO.getUpdateTime().getTime() : templateVersionVO.getCreateTime().getTime()));
        fileInfo.put("oprResult", (Object)true);
        return fileInfo;
    }

    private String getFileType(String fileName) {
        if (fileName.indexOf(".doc") >= 0) {
            return "w";
        }
        if (fileName.indexOf(".xls") >= 0) {
            return "s";
        }
        if (fileName.indexOf(".ppt") >= 0) {
            return "p";
        }
        return "f";
    }

    private String getUrlParam(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            builder.append(URLEncoder.encode(entry.getKey(), "utf-8")).append('=').append(URLEncoder.encode(entry.getValue(), "utf-8"));
        }
        return builder.toString();
    }

    private String getSignature(Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder contents = new StringBuilder("");
        for (String key : keys) {
            if (key == "_w_signature") continue;
            contents.append(key + "=").append(params.get(key));
            System.out.println("key:" + key + ",value:" + params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] byArray = this.hmacSha1(appSecret.getBytes(), contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])byArray);
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(sign);
        return sign;
    }

    public byte[] hmacSha1(byte[] key, byte[] data) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, MultipartFile file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 30000;
        Integer readTimeout = 30000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getOriginalFilename());
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        try {
            WpsCbkController.registerPdf_v_21_7();
        }
        catch (Exception e) {
            throw new RuntimeException("Aspose\u6ce8\u518c\u5931\u8d25", e);
        }
        XLSTransformer transformer = new XLSTransformer();
        File f = new File("D:\\detailList.xlsx");
        FileInputStream is = new FileInputStream(f);
        HashMap<String, List> billData = new HashMap<String, List>();
        File pdfFile = new File("D:\\testPdf2.xlsx");
        String dataJson = "[{\"id\":\"1587401123357642753\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:08:15\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":39,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"JZZXZS\",\"detailName\":\"\u5efa\u7b51\u88c5\u4fee\u88c5\u9970\u5de5\u7a0b\u4e13\u4e1a\u627f\u5305\",\"docPriceTypeName\":null,\"treeIndex\":\"1\",\"detailWorkContent\":null,\"detailMeasurementRules\":null,\"detailUnit\":null,\"detailNum\":null,\"detailPrice\":null,\"detailTaxRate\":11,\"detailMny\":31523489484485.64,\"detailTaxPrice\":31523489484485.2658,\"detailTaxMny\":8531523489484485.12,\"detailTax\":0.96,\"detailMemo\":\"\",\"sourceId\":\"1493124046178713602\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":null,\"tid\":\"1493124046178713602\",\"tpid\":null,\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":null,\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":false,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":null,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401123357642753\",\"parentID\":null,\"shadowId\":\"1587401123357642753\"},{\"id\":\"1587401123357642754\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:08:15\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":39,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"\u6d4b\u8bd5\u91cf\u4ef7\u65b9\u5f0f\",\"docPriceTypeName\":\"\u7efc\u5408\u5355\u4ef7\",\"treeIndex\":\"1.1\",\"detailWorkContent\":\"\u6d4b\u8bd5\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\",\"detailMeasurementRules\":null,\"detailUnit\":\"m\u00b2\",\"detailNum\":1,\"detailPrice\":1.98019802,\"detailTaxRate\":11,\"detailMny\":1.98,\"detailTaxPrice\":2,\"detailTaxMny\":2185641848641641684,\"detailTax\":0.22,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":1,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401123357642754\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587401123357642754\"},{\"id\":\"1587401560194404354\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:09:59\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":38,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"\u6d4b\u8bd5\u91cf\u4ef7\u65b9\u5f0f\",\"docPriceTypeName\":\"\u7efc\u5408\u5355\u4ef7\",\"treeIndex\":\"1.2\",\"detailWorkContent\":\"\u6d4b\u8bd5\",\"detailMeasurementRules\":null,\"detailUnit\":\"m\u00b2\",\"detailNum\":2,\"detailPrice\":1.98019802,\"detailTaxRate\":11,\"detailMny\":3.96,\"detailTaxPrice\":2,\"detailTaxMny\":4,\"detailTax\":0.44,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":2,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401560194404354\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587401560194404354\"},{\"id\":\"1587403062371799041\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:15:57\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":36,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"\u6d4b\u8bd5\u91cf\u4ef7\u65b9\u5f0f\",\"docPriceTypeName\":\"\u7efc\u5408\u5355\u4ef7\",\"treeIndex\":\"1.3\",\"detailWorkContent\":\"\u6d4b\u8bd5\",\"detailMeasurementRules\":null,\"detailUnit\":\"m\u00b2\",\"detailNum\":15,\"detailPrice\":1.98019802,\"detailTaxRate\":1,\"detailMny\":29.7,\"detailTaxPrice\":2,\"detailTaxMny\":30,\"detailTax\":0.3,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":15,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587403062371799041\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587403062371799041\"},{\"id\":\"1591061554461335554\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC\",\"detailName\":\"\u5730\u57fa\u57fa\u7840\u5de5\u7a0b\u4e13\u4e1a\u627f\u5305\",\"docPriceTypeName\":null,\"treeIndex\":\"2\",\"detailWorkContent\":null,\"detailMeasurementRules\":null,\"detailUnit\":null,\"detailNum\":null,\"detailPrice\":null,\"detailTaxRate\":11,\"detailMny\":16035,\"detailTaxPrice\":null,\"detailTaxMny\":17798.85,\"detailTax\":1763.85,\"detailMemo\":\"\u55ef\u55ef\u55ef\",\"sourceId\":\"1493124046233239553\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":null,\"tid\":\"1493124046233239553\",\"tpid\":null,\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":null,\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":false,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":null,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335554\",\"parentID\":null,\"shadowId\":\"1591061554461335554\"},{\"id\":\"1591061554461335555\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"LSD000036\",\"detailName\":\"a\u52b3\u52a1\",\"docPriceTypeName\":null,\"treeIndex\":\"2.1\",\"detailWorkContent\":\"\u6d4b\u8bd51\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52191\",\"detailUnit\":null,\"detailNum\":21,\"detailPrice\":11,\"detailTaxRate\":11,\"detailMny\":231,\"detailTaxPrice\":12.21,\"detailTaxMny\":256.41,\"detailTax\":25.41,\"detailMemo\":\"\u5907\u6ce81\",\"sourceId\":\"591353489054646281\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"591353489054646281\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"591353489054646281\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":21,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335555\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335555\"},{\"id\":\"1591061554461335560\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC008\",\"detailName\":\"\u5730\u9762\u9762\u5c42\",\"docPriceTypeName\":null,\"treeIndex\":\"2.2\",\"detailWorkContent\":\"\u6d4b\u8bd56\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52196\",\"detailUnit\":\"\",\"detailNum\":26,\"detailPrice\":66,\"detailTaxRate\":11,\"detailMny\":1716,\"detailTaxPrice\":73.26,\"detailTaxMny\":1904.76,\"detailTax\":188.76,\"detailMemo\":\"\u5907\u6ce86\",\"sourceId\":\"1493470196802756610\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196802756610\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196802756610\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":26,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335560\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335560\"},{\"id\":\"1591061554461335561\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC012\",\"detailName\":\"\u6a61\u5851\u9762\u5c42\",\"docPriceTypeName\":null,\"treeIndex\":\"2.3\",\"detailWorkContent\":\"\u6d4b\u8bd57\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52197\",\"detailUnit\":\"\",\"detailNum\":27,\"detailPrice\":77,\"detailTaxRate\":11,\"detailMny\":2079,\"detailTaxPrice\":85.47,\"detailTaxMny\":2307.69,\"detailTax\":228.69,\"detailMemo\":\"\u5907\u6ce87\",\"sourceId\":\"1493470196853088258\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196853088258\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196853088258\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":27,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335561\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335561\"},{\"id\":\"1591061554461335562\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC013\",\"detailName\":\"\u6728\u7af9\u9762\u5c42\",\"docPriceTypeName\":null,\"treeIndex\":\"2.4\",\"detailWorkContent\":\"\u6d4b\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd5\u6d4b\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b\u8bd51\u6d4b1\u6d4b\u8bd51\u8bd58\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52198\",\"detailUnit\":\"\",\"detailNum\":28,\"detailPrice\":88,\"detailTaxRate\":11,\"detailMny\":2464,\"detailTaxPrice\":97.68,\"detailTaxMny\":2735.04,\"detailTax\":271.04,\"detailMemo\":\"\u5907\u6ce88\",\"sourceId\":\"1493470196869865474\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196869865474\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196869865474\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":28,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335562\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335562\"},{\"id\":\"1591061554461335563\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC014\",\"detailName\":\"\u9632\u6c34\u65bd\u5de5\uff08\u4eba\u5de5\uff09\",\"docPriceTypeName\":null,\"treeIndex\":\"2.5\",\"detailWorkContent\":\"\u6d4b\u8bd59\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52199\",\"detailUnit\":\"\",\"detailNum\":29,\"detailPrice\":99,\"detailTaxRate\":11,\"detailMny\":2871,\"detailTaxPrice\":109.89,\"detailTaxMny\":3186.81,\"detailTax\":315.81,\"detailMemo\":\"\u5907\u6ce89\",\"sourceId\":\"1493470196878254081\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196878254081\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196878254081\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":29,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335563\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335563\"},{\"id\":\"1591061554461335564\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC015\",\"detailName\":\"\u5c4b\u9762\u4e0a\u53e3\u76d6\u677f\u5b89\u88c5\",\"docPriceTypeName\":null,\"treeIndex\":\"2.6\",\"detailWorkContent\":\"\u6d4b\u8bd510\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u521910\",\"detailUnit\":\"\",\"detailNum\":30,\"detailPrice\":100,\"detailTaxRate\":11,\"detailMny\":3000,\"detailTaxPrice\":111,\"detailTaxMny\":3330,\"detailTax\":330,\"detailMemo\":\"\u5907\u6ce810\",\"sourceId\":\"1493470196886642689\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196886642689\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196886642689\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":30,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335564\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335564\"},{\"id\":\"1591061554461335556\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC001\",\"detailName\":\"\u6574\u4f53\u9762\u5c42\",\"docPriceTypeName\":\"\u91cf\u4ef7\u65b9\u5f0f\",\"treeIndex\":\"2.7\",\"detailWorkContent\":\"\u6d4b\u8bd52\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52192\",\"detailUnit\":\"\",\"detailNum\":22,\"detailPrice\":22,\"detailTaxRate\":11,\"detailMny\":484,\"detailTaxPrice\":24.42,\"detailTaxMny\":537.24,\"detailTax\":53.24,\"detailMemo\":\"\u5907\u6ce82\",\"sourceId\":\"1493470196605624321\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196605624321\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196605624321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":22,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"180.0000-180.0000\",\"historyTaxPriceArea\":\"0.0000-0.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335556\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335556\"},{\"id\":\"1591061554461335557\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC004\",\"detailName\":\"\u5730\u7816\u7c98\u8d34\",\"docPriceTypeName\":\"\u91cf\u4ef7\u65b9\u5f0f\",\"treeIndex\":\"2.8\",\"detailWorkContent\":\"\u6d4b\u8bd53\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52193\",\"detailUnit\":\"\",\"detailNum\":23,\"detailPrice\":33,\"detailTaxRate\":11,\"detailMny\":759,\"detailTaxPrice\":36.63,\"detailTaxMny\":842.49,\"detailTax\":83.49,\"detailMemo\":\"\u5907\u6ce83\",\"sourceId\":\"1493470196744036353\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196744036353\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196744036353\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":23,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"10.0000-50.0000\",\"historyTaxPriceArea\":\"10.1000-50.5000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335557\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335557\"},{\"id\":\"1591061554461335558\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC006\",\"detailName\":\"\u5730\u9762\u57ab\u5c42\",\"docPriceTypeName\":\"\u91cf\u4ef7\u65b9\u5f0f\",\"treeIndex\":\"2.9\",\"detailWorkContent\":\"\u6d4b\u8bd54\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52194\",\"detailUnit\":\"\",\"detailNum\":24,\"detailPrice\":44,\"detailTaxRate\":11,\"detailMny\":1056,\"detailTaxPrice\":48.84,\"detailTaxMny\":1172.16,\"detailTax\":116.16,\"detailMemo\":\"\u5907\u6ce84\",\"sourceId\":\"1493470196777590785\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196777590785\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196777590785\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":24,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"10.0000-10.0000\",\"historyTaxPriceArea\":\"10.1000-10.1000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335558\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335558\"},{\"id\":\"1591061554461335559\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC007\",\"detailName\":\"\u5916\u5899\u9762\u7816\u7c98\u8d34\",\"docPriceTypeName\":null,\"treeIndex\":\"2.10\",\"detailWorkContent\":\"\u6d4b\u8bd55\",\"detailMeasurementRules\":\"\u8ba1\u91cf\u89c4\u52195\",\"detailUnit\":\"\",\"detailNum\":25,\"detailPrice\":55,\"detailTaxRate\":11,\"detailMny\":1375,\"detailTaxPrice\":61.05,\"detailTaxMny\":1526.25,\"detailTax\":151.25,\"detailMemo\":\"\u5907\u6ce85\",\"sourceId\":\"1493470196794368002\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196794368002\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196794368002\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":25,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335559\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335559\"}]";
        List data = JSONObject.parseArray((String)dataJson, JSONObject.class);
        billData.put("detailList", data);
        FileOutputStream outs = new FileOutputStream(pdfFile);
        Workbook workbook = transformer.transformXLS((InputStream)is, billData);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        Sheet sheet = workbook.getSheetAt(0);
        sheet.setAutobreaks(true);
        WpsCbkController.autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum(), cellStyle);
        workbook.write((OutputStream)outs);
        File pdfF = new File("D:\\test.pdf");
        File excelFile = new File("D:\\testPdf2.xlsx");
        FileOutputStream outs2 = new FileOutputStream(pdfF);
        FileInputStream fis = new FileInputStream(excelFile);
        com.aspose.cells.Workbook cellBook = new com.aspose.cells.Workbook((InputStream)fis);
        int[] autoDrawSheets = new int[]{1};
        WpsCbkController.autoDraw(cellBook, autoDrawSheets);
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
        cellBook.save((OutputStream)outs2, (SaveOptions)pdfSaveOptions);
        outs2.flush();
        ((OutputStream)outs2).close();
        ((InputStream)fis).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File byte2file(byte[] bytes, String fileFullPath) {
        if (bytes == null) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(fileFullPath);
            if (file.exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes);
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void registerPdf_v_21_7() throws Exception {
        Date licenseExpiry = new Date(Long.MAX_VALUE);
        Class<?> l9yClass = Class.forName("com.aspose.pdf.l9y");
        Constructor<?> constructor = l9yClass.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object l9yInstance = constructor.newInstance(new Object[0]);
        Field lc = l9yClass.getDeclaredField("lc");
        lc.setAccessible(true);
        lc.set(l9yInstance, licenseExpiry);
        Field ly = l9yClass.getDeclaredField("ly");
        ly.setAccessible(true);
        ly.set(l9yInstance, licenseExpiry);
        Field l0if = l9yClass.getDeclaredField("l0if");
        l0if.setAccessible(true);
        Class<?> l9nClass = Class.forName("com.aspose.pdf.l9n");
        Field lfField = l9nClass.getDeclaredField("lf");
        lfField.setAccessible(true);
        Object lf = lfField.get(null);
        l0if.set(l9yInstance, lf);
        Class<?> l9yLfClass = Class.forName("com.aspose.pdf.l9y$lf");
        Field l9y$lf = l9yLfClass.getDeclaredField("lI");
        l9y$lf.setAccessible(true);
        l9y$lf.set(null, l9yInstance);
        Class<?> l19jClass = Class.forName("com.aspose.pdf.l19j");
        Field l19jlI = l19jClass.getDeclaredField("lI");
        l19jlI.setAccessible(true);
        l19jlI.set(null, 128);
        Field l19jLf = l19jClass.getDeclaredField("lf");
        l19jLf.setAccessible(true);
        l19jLf.set(null, false);
    }

    public static void autoDraw(com.aspose.cells.Workbook wb, int[] page) {
        if (null != page && page.length > 0) {
            for (int i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    public static float getExcelCellAutoHeight(String str, float fontCountInline) {
        float defaultRowHeight = 12.0f;
        float defaultCount = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            float ff = WpsCbkController.getregex(str.substring(i, i + 1));
            defaultCount += ff;
        }
        return (float)((int)(defaultCount / fontCountInline) + 1) * defaultRowHeight;
    }

    public static float getregex(String charStr) {
        if (charStr == " ") {
            return 0.5f;
        }
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.0f;
        }
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.0f;
        }
        return 0.5f;
    }

    public static void autoColumnWidthForChineseChar(Sheet sheet, int startColumnNum, int size, CellStyle defaultCellStyle) {
        int oneLineHeight = 200;
        int twentyWordsColumnWidth = 15360;
        int fortyFiveWordsColumnWidth = 34560;
        int sixtyWordsColumnWidth = 46080;
        int actualColWith = 15360;
        Integer rowContentMaxHeight = 1;
        Integer curCellContentHeight = 1;
        String[] breakRow = null;
        int[] breakRowCount = null;
        HashMap<Integer, Integer> colMaxWidth = new HashMap<Integer, Integer>();
        CellStyle cellStyle = null;
        Workbook workbook = sheet.getWorkbook();
        for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row currentRow = sheet.getRow(rowNum);
            rowContentMaxHeight = 1;
            breakRow = null;
            breakRowCount = null;
            actualColWith = 15360;
            for (int columnNum = 0; columnNum < size; ++columnNum) {
                int columnWidth;
                int newWidth = columnWidth = sheet.getColumnWidth(columnNum);
                boolean newHeight = false;
                actualColWith = 15360;
                curCellContentHeight = 1;
                if (currentRow.getCell(columnNum) != null) {
                    Cell currentCell = currentRow.getCell(columnNum);
                    String value = WpsCbkController.getCellContentAsString(currentCell);
                    oneLineHeight = workbook.getFontAt(currentCell.getCellStyle().getFontIndex()).getFontHeightInPoints() * 20;
                    int count = 0;
                    if (rowNum == 3 && columnNum == 3) {
                        System.out.println(value);
                    }
                    if (value.indexOf("\n") > -1) {
                        breakRow = value.split("\n");
                        breakRowCount = new int[breakRow.length];
                        int maxRowCNNum = 20;
                        for (int bi = 0; bi < breakRow.length; ++bi) {
                            breakRowCount[bi] = WpsCbkController.chineseCharCountOf(breakRow[bi]);
                            maxRowCNNum = breakRowCount[bi] > maxRowCNNum ? breakRowCount[bi] : maxRowCNNum;
                        }
                        maxRowCNNum = maxRowCNNum > 45 ? (maxRowCNNum > 60 ? 60 : 45) : maxRowCNNum;
                        for (int rowCnNum : breakRowCount) {
                            count += (rowCnNum / maxRowCNNum + rowCnNum % maxRowCNNum == 0 ? 0 : 1) * maxRowCNNum;
                        }
                    } else {
                        count = WpsCbkController.chineseCharCountOf(value);
                    }
                    newWidth = value.length() * 256 + count * 256 * 2;
                    cellStyle = currentCell.getCellStyle();
                    if (null == cellStyle) {
                        currentCell.setCellStyle(defaultCellStyle);
                    } else {
                        cellStyle.setWrapText(true);
                        currentCell.setCellStyle(cellStyle);
                    }
                }
                if (null == colMaxWidth.get(columnNum) || newWidth > (Integer)colMaxWidth.get(columnNum)) {
                    if (newWidth > actualColWith) {
                        if (Math.ceil(Double.valueOf(newWidth) / (double)actualColWith) > 30.0) {
                            actualColWith = Math.ceil(Double.valueOf(newWidth) / 34560.0) <= 30.0 ? 34560 : 46080;
                        }
                        if ((curCellContentHeight = Integer.valueOf(Double.valueOf(Math.ceil(Double.valueOf(newWidth) / (double)actualColWith)).intValue())) > rowContentMaxHeight) {
                            rowContentMaxHeight = curCellContentHeight;
                        }
                    } else {
                        actualColWith = newWidth;
                    }
                    if (null == colMaxWidth.get(columnNum)) {
                        colMaxWidth.put(columnNum, 0);
                    }
                    if (actualColWith > (Integer)colMaxWidth.get(columnNum)) {
                        colMaxWidth.put(columnNum, actualColWith);
                    }
                    sheet.setColumnWidth(columnNum, actualColWith);
                    continue;
                }
                sheet.setColumnWidth(columnNum, ((Integer)colMaxWidth.get(columnNum)).intValue());
            }
            if (rowNum == 1) {
                currentRow.setHeight(Double.valueOf(oneLineHeight * rowContentMaxHeight * 2).shortValue());
                continue;
            }
            currentRow.setHeight(Double.valueOf((double)oneLineHeight * (rowContentMaxHeight == 1 ? 2.0 : (double)rowContentMaxHeight.intValue() * 1.3)).shortValue());
        }
    }

    private static String getCellContentAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case 0: {
                String s = String.valueOf(cell.getNumericCellValue());
                if (s != null && s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                result = s;
                break;
            }
            case 1: {
                result = null != cell.getStringCellValue() ? String.valueOf(cell.getStringCellValue()).trim() : "";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                break;
            }
        }
        return result;
    }

    private static int chineseCharCountOf(String input) {
        int count = 0;
        if (null != input) {
            String regEx = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(input);
            int len = m.groupCount();
            while (m.find()) {
                for (int i = 0; i <= len; ++i) {
                    ++count;
                }
            }
        }
        return count;
    }
}

