package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.CheckHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-wzxt-web", url="${common.env.feign-client-url}", path="ejc-wzxt-web", fallback = CheckHystrix.class)
//@FeignClient(name= "ejc-wzxt-web", url="${common.env.feign-client-url}", path="ejc-wzxt-web", configuration = {KeepErrMsgConfiguration.class})
public interface ICheckApi {

	/**
	 * 修改验收单引用状态
	 * @param checkId
	 * @param useState
	 * @return
	 */
	@GetMapping(value = "/api/check/updateUseState")
	public CommonResponse<Boolean> updateUseState(@RequestParam(value = "checkId", required = true) Long checkId, @RequestParam("useState") Integer useState);

}
