package com.ejianc.business.wzxt.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.wzxt.vo.PickingOutStoreDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 领料出库（主）
 * 
 * @author generator
 * 
 */
public class PickingOutStoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 出库单号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date outDate; // 出库日期
    private Long orgId; // 出库组织id
    private String orgName; // 出库组织名称
    private String materialNames; // 出库物资名称集合
    private java.math.BigDecimal outNum; // 出库数量
    private String useFor; // 用处
    private String memo; // 备注
    private String creatorName; // 编制人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date creatorTime;//编制日期
    private String projectName; // 出库项目名称
    private Long projectId; // 出库项目id
    private String projectSourceId;//项目sourceId
    private Long pickingUnitId; // 领料单位id
    private String pickingUnitName; // 领料单位名称
    private String pickingName; // 领料人名称
    private Long pickingId; // 领料人id
    
    private List<PickingOutStoreDetailVO> pickingOutStoreDetailEntities = new ArrayList<>(); // 领料出库（子）


    /**
     * 项目sourceId
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    /**
     * 编制人时间
     */
    public Date getCreatorTime() {
        return creatorTime;
    }

    public void setCreatorTime(Date creatorTime) {
        this.creatorTime = creatorTime;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 出库单号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 出库单号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 出库日期
     */
    public java.util.Date getOutDate() {
        return outDate;
    }

    /**
     * 出库日期
     */
    public void setOutDate(java.util.Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 出库组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 出库组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 出库组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 出库组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 出库物资名称集合
     */
    public String getMaterialNames() {
        return materialNames;
    }

    /**
     * 出库物资名称集合
     */
    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    /**
     * 出库数量
     */
    public java.math.BigDecimal getOutNum() {
        return outNum;
    }

    /**
     * 出库数量
     */
    public void setOutNum(java.math.BigDecimal outNum) {
        this.outNum = outNum;
    }
    /**
     * 用处
     */
    public String getUseFor() {
        return useFor;
    }

    /**
     * 用处
     */
    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 编制人
     */
    public String getCreatorName() {
        return creatorName;
    }

    /**
     * 编制人
     */
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }
    /**
     * 出库项目名称
     */

    public String getProjectName() {
        return projectName;
    }

    /**
     * 出库项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 出库项目id
     */
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 出库项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 领料单位id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getPickingUnitId() {
        return pickingUnitId;
    }

    /**
     * 领料单位id
     */
    @ReferDeserialTransfer
    public void setPickingUnitId(Long pickingUnitId) {
        this.pickingUnitId = pickingUnitId;
    }
    /**
     * 领料单位名称
     */
    public String getPickingUnitName() {
        return pickingUnitName;
    }

    /**
     * 领料单位名称
     */
    public void setPickingUnitName(String pickingUnitName) {
        this.pickingUnitName = pickingUnitName;
    }
    /**
     * 领料人名称
     */
    public String getPickingName() {
        return pickingName;
    }

    /**
     * 领料人名称
     */
    public void setPickingName(String pickingName) {
        this.pickingName = pickingName;
    }
    /**
     * 领料人id
     */
//    @ReferSerialTransfer(referCode = "")
    public Long getPickingId() {
        return pickingId;
    }

    /**
     * 领料人id
     */
//    @ReferDeserialTransfer
    public void setPickingId(Long pickingId) {
        this.pickingId = pickingId;
    }
    
     /**
      * 领料出库（子）
      */
     public List<PickingOutStoreDetailVO> getPickingOutStoreDetailEntities() {
        return pickingOutStoreDetailEntities;
     }

     /**
      * 领料出库（子）
      */
     public void setPickingOutStoreDetailEntities(List<PickingOutStoreDetailVO> pickingOutStoreDetailEntities) {
        this.pickingOutStoreDetailEntities = pickingOutStoreDetailEntities;
     }
}
