package com.ejianc.business.wzxt.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 订单实体
 * 
 * @author generator
 * 
 */
public class OrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Long projectId; // 项目
    private java.lang.String projectSourceId; // 项目来源id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.String contractId; // 合同主键
    private java.lang.String contractName; // 合同名称
    private java.lang.Long supplierId; // 设备供应商
    private java.lang.String supplierName; // 供应商名称
    private java.lang.Long supplierTenantId; // 供应商租户ID
    private java.lang.String materialName; // 物资名称
    private java.lang.String construction; // 施工部位
    private java.lang.Long commitId; // 提交人
    private java.lang.Long employeeId; // 经办人
    private java.lang.String employeeName; // 经办人名称
    private java.lang.Long linkId; // 联系人
    private java.lang.String linkName; // 联系人名称
    private java.lang.String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date orderCreateDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date orderExpiryDate; // 到货日期
    private java.lang.String orderNote; // 送货要求
    private java.lang.String orderAddress; // 送货地址
    private java.lang.Integer receiveState; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    private java.lang.Integer deliverState; // 发货状态（0-待发货，1-已发货，2-已验收）
    private java.lang.String receiveStateName; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    private java.lang.String deliverStateName; // 发货状态（0-待发货，1-已发货，2-已验收）
    private java.lang.Integer billState; // 单据状态（审批必须字段）

    private java.math.BigDecimal orderNumsSum; // 订单数量
    private java.math.BigDecimal deliverNumsSum; // 发货数量
    private java.math.BigDecimal unDeliverNumsSum; // 未发货数量
    private java.math.BigDecimal receiveNumsSum; // 接收数量

    private String billStateName;
    private String isPushThird; // 推送第三方是否成功 sucPushed   unSucPush
    private String unSucReason;//失败原因
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private Integer ignoreFlag; // 是否忽略（0：正常，1忽略）

    public String getIsPushThird() {
        return isPushThird;
    }

    public void setIsPushThird(String isPushThird) {
        this.isPushThird = isPushThird;
    }

    public String getUnSucReason() {
        return unSucReason;
    }

    public void setUnSucReason(String unSucReason) {
        this.unSucReason = unSucReason;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public Integer getIgnoreFlag() {
        return ignoreFlag;
    }

    public void setIgnoreFlag(Integer ignoreFlag) {
        this.ignoreFlag = ignoreFlag;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }

    public BigDecimal getDeliverNumsSum() {
        return deliverNumsSum;
    }

    public void setDeliverNumsSum(BigDecimal deliverNumsSum) {
        this.deliverNumsSum = deliverNumsSum;
    }

    public BigDecimal getUnDeliverNumsSum() {
        return unDeliverNumsSum;
    }

    public void setUnDeliverNumsSum(BigDecimal unDeliverNumsSum) {
        this.unDeliverNumsSum = unDeliverNumsSum;
    }

    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }

    // 采购订单明细子表
    private List<OrderDetailVO> purchaseOrderDetail = new ArrayList<OrderDetailVO>();

    public List<OrderDetailVO> getPurchaseOrderDetail() {
        return purchaseOrderDetail;
    }

    public void setPurchaseOrderDetail(List<OrderDetailVO> purchaseOrderDetail) {
        this.purchaseOrderDetail = purchaseOrderDetail;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getDeliverStateName() {
        return deliverStateName;
    }

    public void setDeliverStateName(String deliverStateName) {
        this.deliverStateName = deliverStateName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商租户ID
     */
    public java.lang.Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户ID
     */
    public void setSupplierTenantId(java.lang.Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }


    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public java.util.Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(java.util.Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public java.util.Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(java.util.Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(java.lang.String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(java.lang.String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public java.lang.Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public void setReceiveState(java.lang.Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
}
