package com.ejianc.business.wzxt.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.wzxt.hystrix.CheckHystrix;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 获取订单内所有项目方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-wzxt-web", url="${common.env.feign-client-url}", path="ejc-wzxt-web", fallback = CheckHystrix.class)
public interface IOrderApi {

	/**
	 * 根据供应商主键获取订单里的项目
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/order/queryOrderProjects")
	public CommonResponse<IPage<OrderProjectVO>> queryOrderProjects(@RequestParam(defaultValue = "1") Integer pageNumber,
																	@RequestParam(defaultValue = "10") Integer pageSize,
																	@RequestParam(value = "condition", required = false) String condition,
																	@RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 根据物资明细id 获取订单详情
	 *
	 */
	@RequestMapping(
			value = {"/api/delivery/queryOrderByDetailId"},
			method = {RequestMethod.GET}
	)
	CommonResponse<OrderVO> queryOrderByDetailId(@RequestParam("detailId") Long detailId);
}
