package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 使用计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plan")
public class PlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanService planService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return planService.saveOrUpdate(planVO);

    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
    	PlanEntity entity = planService.selectById(id);
    	PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        planService.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<PlanEntity> page = planService.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("使用计划分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<PlanEntity> pageData= planService.queryPage(param,false);
        List<PlanVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), PlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("planExport.xlsx", beans, response);
    }
}
