/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WZXT_PURCHASE_BILL_CODE = "WZXT_PURCHASE";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)orderVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                orderVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)orderVO, OrderEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
    }
}

