/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private static final String WZXT_PLAN_BILL_CODE = "WZXT_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)planVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                planVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class));
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if (planDetail != null && planDetail.size() > 0) {
            for (PlanDetailEntity applyDetailEntity : planDetail) {
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.planService.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

