package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.OrderVO;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("purchaseOrder")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOrderService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity entity = service.selectById(id);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnConfirmedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnconfirmedList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("supplierTenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 状态为待确认 */
        param.getParams().put("receiveState", new Parameter(QueryParam.EQ, 0));
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnDeliverList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnDeliverList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("supplierTenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 状态为待发货 */
        param.getParams().put("deliverState", new Parameter(QueryParam.EQ, 0));
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  更新接收状态
     */
    @RequestMapping(value = "/updateReceived", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！",service.updateReceived(saveorUpdateVO));
    }
}
