package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;

import java.math.BigDecimal;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String WZXT_PURCHASE_BILL_CODE = "WZXT_PURCHASE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(orderVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                orderVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OrderVO.class);
    }

    @Override
    public OrderVO updateReceived(OrderVO orderVO) {
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderVO.setReceiveState(1);//全部接收
            orderVO.setDeliverState(0);//待发货
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    // to do
                    vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    vo.setUnDeliverNumsSum(vo.getOrderNumsSum());//未发货数量
                });
            }
        }else if(2==orderVO.getReceiveState()){
            orderVO.setReceiveState(2);//部分接收
            orderVO.setDeliverState(0);//待发货
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    // to do 回写计划量

                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    vo.setUnDeliverNumsSum(vo.getReceiveNumsSum());//未发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
          //已拒绝
            orderVO.setReceiveState(3);//拒绝
//            orderVO.setDeliverState(0);//待发货
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    // to do
                    vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    vo.setUnDeliverNumsSum(BigDecimal.ZERO);//未发货数量
                });
            }

        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OrderVO.class);
    }
}
