/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"plan"})
public class PlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO planVO) {
        return this.planService.saveOrUpdate(planVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = (PlanEntity)((Object)this.planService.selectById(id));
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        this.planService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.planService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u4f7f\u7528\u8ba1\u5212\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.planService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), PlanVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("planExport.xlsx", beans, response);
    }

    @GetMapping(value={"/planRef"})
    @ResponseBody
    public CommonResponse<JSONObject> planRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        PlanVO planVO = new PlanVO();
        planVO.setTenantId(InvocationInfoProxy.getTenantid());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<PlanDetailVO> list = this.planDetailService.geMaterialDetail((Page<PlanDetailVO>)page, wrapper);
        ArrayList<Long> materialListId = new ArrayList<Long>();
        for (PlanDetailVO planDetailVO : list) {
            materialListId.add(planDetailVO.getMaterialId());
        }
        QueryParam queryDetailParam = new QueryParam();
        queryDetailParam.getParams().put("materialId", new Parameter("in", materialListId));
        List<PlanVO> planVOList = this.planService.getPlanByMaterialId(materialListId);
        for (PlanDetailVO planDetailVO : list) {
            ArrayList<PlanVO> planDetail = new ArrayList<PlanVO>();
            for (PlanVO planVOChild : planVOList) {
                if (!planDetailVO.getMaterialId().equals(planVOChild.getMaterialId())) continue;
                planDetail.add(planVOChild);
            }
            planDetailVO.setChildren(planDetail);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

