package com.ejianc.business.wzxt.controller.api;

import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/check/")
public class CheckApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICheckService checkService;
	
	@RequestMapping(value = "updateUseState", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Boolean> updateUseState(
			@RequestParam(value="checkId", required=true) Long checkId,
			@RequestParam(value="useState", required=false) Integer useState) {
		CheckEntity entity = checkService.selectById(checkId);
		entity.setUseState(useState);
		return CommonResponse.success(checkService.updateById(entity));
	}

}
