package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String WZXT_PURCHASE_BILL_CODE = "WZXT_PURCHASE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(orderVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                orderVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        StringBuffer materialName = new StringBuffer();

        List<PlanDetailEntity> listedit = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(null!=vo.getLeafFlag()&&!vo.getLeafFlag()){
                    materialName.append(vo.getMaterialName()+",");
                }
                if(null==vo.getLeafFlag()||vo.getLeafFlag()){
                    //说明是子集
                    vo.setLeafFlag(true);
                    if(null!=vo.getId()){
                        if("del".equals(vo.getRowState())){
                            //说明是子集删除
                            PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                            BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                            BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                            entity.setOccupyNums(occupyNums.subtract(orderNums));
                            entity.setSurplusNums(surplusNums.add(orderNums));
                            listedit.add(entity);
                        }else{
                            OrderDetailEntity detailEntity = orderDetailService.getById(vo.getPlanDetailId());
                            BigDecimal orderNumsDb = detailEntity.getOrderNumsSum()==null?BigDecimal.ZERO:detailEntity.getOrderNumsSum();// 数据库数量
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();//前端传的数量
                            if(orderNums.compareTo(orderNumsDb)!=0){
                                BigDecimal subtractNum = orderNumsDb.subtract(orderNums);//例子  前端传80，数据库为100  则差值为20
                                //说明订单数量有修改
                                PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                                BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                                BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                                if(surplusNums.add(subtractNum).compareTo(BigDecimal.ZERO)<0){
                                    throw new BusinessException("订单数量不能超过计划剩余量，该计划明细实际剩余量为【"+surplusNums+"】!");
                                }
                                entity.setOccupyNums(occupyNums.subtract(subtractNum));
                                entity.setSurplusNums(surplusNums.add(subtractNum));
                                listedit.add(entity);

                            }
                        }
                    }else{
                        //说明是子集新增
                        PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                        BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                        BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();// 剩余
                        BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                        if(surplusNums.subtract(orderNums).compareTo(BigDecimal.ZERO)<0){
                            throw new BusinessException("订单数量不能超过计划剩余量，该计划明细实际剩余量为【"+surplusNums+"】!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums));
                        entity.setSurplusNums(surplusNums.subtract(orderNums));
                        listedit.add(entity);
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(listedit)){
                planDetailService.updateBatchById(listedit);
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            orderVO.setMaterialName(materialNames);
        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
//        entity.setReceiveState(0);
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public OrderVO updateReceived(OrderVO orderVO) {
        List<OrderDetailEntity> entityList = new ArrayList<>();
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderVO.setReceiveState(1);//全部接收
            orderVO.setDeliverState(0);//待发货

            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail());
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    vo.setUnDeliverNumsSum(vo.getOrderNumsSum());//未发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
          //已拒绝
            orderVO.setReceiveState(3);//拒绝
//            orderVO.setDeliverState(0);//待发货
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail());
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    // to do
                    vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    vo.setUnDeliverNumsSum(BigDecimal.ZERO);//未发货数量
                });
            }

        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        super.saveOrUpdate(entity, false);
        return orderVO;
    }

    @Override
    public OrderVO updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = super.selectById(orderVO.getId());

        orderVO.setReceiveState(2);//部分接收
        orderVO.setDeliverState(0);//待发货
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            //拆分接收数量
            OrderDetailBack(orderVO.getPurchaseOrderDetail());
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                vo.setUnDeliverNumsSum(vo.getReceiveNumsSum());//未发货数量
            });
        }
        orderVO.setBillState(orderEntity.getBillState());
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OrderVO.class);
    }

    public void OrderDetailBack(List<OrderDetailVO> detailList){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<PlanDetailEntity> planDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                //查询订单数量>接收数量的明细  根据主键正序排
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId,vo.getTid());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                lambda.orderByAsc(OrderDetailEntity::getId);
                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//汇总的接收数量
                    //forEach  不能这样用    xx = xx.subtract(xx);
                    for(int i=0;i<details.size();i++){

                        BigDecimal orderNumsSum = details.get(i).getOrderNumsSum()==null?BigDecimal.ZERO:details.get(i).getOrderNumsSum();//订单量
                        if(receiveNumsSum.compareTo(BigDecimal.ZERO)>0){
                            if(receiveNumsSum.compareTo(orderNumsSum)>=0){
                                //接收数量  大于该行  剩余可接收数量，则直接将该行  接收数量=订单数量即可
                                details.get(i).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            }else{
                                //接收数量  小于该行  剩余可接收数量，则直接将该行  接收数量=原来订单数量+行汇总后的剩余接收数量
                                details.get(i).setReceiveNumsSum(receiveNumsSum);
                                //此时需要回写计划订单明细对应的占用金额
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));//后续批量更新
                        }else {
                            PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                            planDetailList.add(planDetailEntity);
                        }
                    }
                    //批量更新订单明细
                    if(CollectionUtils.isNotEmpty(entityList)){
                        orderDetailService.updateBatchById(entityList);
                    }
                    //批量更新计划明细
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }


    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = super.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);

        List<OrderDetailVO> listres = new ArrayList<>();
        List<OrderDetailVO> list = orderVO.getPurchaseOrderDetail();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(vo.getParentId().equals(999L)){
                    listres.add(vo);
                }
                // to do
//                BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//接收数量
//                BigDecimal deliverNumsSum = vo.getDeliverNumsSum()==null?BigDecimal.ZERO:vo.getDeliverNumsSum();//发货数量
//                vo.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));//未发货数量
            });

            listres.forEach(vo -> {
                List<OrderDetailVO> listd = new ArrayList<>();
                list.forEach(e -> {
                    if(vo.getTid().equals(e.getParentId())){
                        listd.add(e);
                    }
                });
                vo.setChildren(listd);
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        return orderVO;
    }
}
