/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WZXT_CHECK = "WZXT_CHECK";
    @Autowired
    private ICheckService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveorUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCheckState(1);
        if (entity.getUseState() == null) {
            entity.setUseState(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdateTemp(@RequestBody CheckVO saveorUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCheckState(0);
        if (entity.getUseState() == null) {
            entity.setUseState(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkState", new Parameter("ne", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkState", new Parameter("ne", (Object)0));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList commonOrgIds = new ArrayList();
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                String checkTypeName = "";
                if (vo.getCheckType().equals("1")) {
                    checkTypeName = "\u81ea\u8d2d\u6d88\u8017\u6750";
                } else if (vo.getCheckType().equals("2")) {
                    checkTypeName = "\u81ea\u8d2d\u5468\u8f6c\u6750";
                } else if (vo.getCheckType().equals("3")) {
                    checkTypeName = "\u79df\u8d41\u5468\u8f6c\u6750";
                } else if (vo.getCheckType().equals("4")) {
                    checkTypeName = "\u96f6\u661f\u91c7\u8d2d";
                }
                vo.setCheckTypeName(checkTypeName);
                String useStateName = "";
                useStateName = vo.getUseState() != null && vo.getUseState() == 1 ? "\u5df2\u5f15\u7528" : "\u672a\u5f15\u7528";
                vo.setUseStateName(useStateName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/querTempList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> querTempList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkState", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querCheckedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> querCheckedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkState", new Parameter("eq", (Object)3));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querAnalysisList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> querAnalysisList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CheckAnalysisVO> list = this.service.querAnalysisList((Page<CheckAnalysisVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

