package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 订单明细表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("/orderDetail")
public class OrderDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOrderDetailService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderDetailVO> saveOrUpdate(@RequestBody OrderDetailVO saveorUpdateVO) {
    	OrderDetailEntity entity = BeanMapper.map(saveorUpdateVO, OrderDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	OrderDetailVO vo = BeanMapper.map(entity, OrderDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderDetailVO> queryDetail(Long id) {
    	OrderDetailEntity entity = service.selectById(id);
    	OrderDetailVO vo = BeanMapper.map(entity, OrderDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderDetailVO> vos) {
        service.removeByIds(vos.stream().map(OrderDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<OrderDetailEntity> page = service.queryPage(param,false);
        IPage<OrderDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 订单明细参照，只返回一级
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "orderDetailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderDetailVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialCode");
        Page<OrderDetailEntity> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orderId")) {
                Long orderId = Long.valueOf(conditionMap.get("orderId").toString());
                queryParam.getParams().put("order_id",new Parameter("eq",orderId));
            }
        }
        queryParam.getParams().put("leaf_flag",new Parameter("eq",false));
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.apply("IFNULL(receive_nums_sum,0) > IFNULL(deliver_nums_sum,0)");
        IPage<OrderDetailEntity> pageData = service.selectPage(page,wrapper);
        
        IPage<OrderDetailVO> voPage = new Page<>();
        voPage.setCurrent(pageData.getCurrent());
        voPage.setPages(pageData.getPages());
        voPage.setTotal(pageData.getTotal());
        voPage.setSize(queryParam.getPageSize());
        voPage.setRecords(BeanMapper.mapList(pageData.getRecords(),OrderDetailVO.class));
        return CommonResponse.success("查询列表数据成功！", voPage);
    }

}
