package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.DeliveryDetailVO;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 发货实体
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public DeliveryVO queryDetails(Long id) {
        OrderEntity entity = orderService.selectById(id);
        DeliveryVO deliveryVO = BeanMapper.map(entity, DeliveryVO.class);
        //新增逻辑处理
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        return deliveryVO;
    }
    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(deliveryVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_DELIVERY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                deliveryVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        DeliveryEntity entity = BeanMapper.map(deliveryVO, DeliveryEntity.class);
        //汇总物资明细名称
        List<DeliveryDetailEntity> planDetail = entity.getDeliveryDetail();
        String materialName = "";
        if(planDetail != null && planDetail.size() > 0){
            for(DeliveryDetailEntity deliveryDetailEntity : planDetail){
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        deliveryService.saveOrUpdate(entity, false);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
