package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;

import java.util.ArrayList;
import java.util.List;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private static final String WZXT_CHECK = "WZXT_CHECK";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveorUpdateVO, CheckEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 新增
        if(entity.getId() == null){
            // 未引用
            entity.setUseState(0);
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return baseMapper.querAnalysisList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        vo.setProjectId(delivery.getProjectId());// 项目主键
        vo.setProjectName(delivery.getProjectName());// 项目名称
        vo.setOrgId(delivery.getOrgId());// 组织主键
        vo.setOrgName(delivery.getOrgName());// 组织名称
        vo.setContractId(delivery.getContractId());// 合同主键
        vo.setContractName(delivery.getContractName());// 合同名称
        vo.setSupplierId(delivery.getSupplierId());// 供方主键
        vo.setSupplierName(delivery.getSupplierName());// 供方名称
        vo.setSupplierTenantId(delivery.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(delivery.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(delivery.getMaterialName());// 物资名称
        vo.setOrderId(delivery.getOrderId());// 订单主键
        vo.setDeliveryId(deliveryId);// 发货单主键
        // 发货单明细生成验收单明细
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(
                new LambdaQueryWrapper<DeliveryDetailEntity>().eq(DeliveryDetailEntity::getDeliveryId, delivery.getId()));
        if(CollectionUtils.isNotEmpty(deliveryDetailList)){
            List<CheckDetailVO> detailList = new ArrayList<>();
            deliveryDetailList.forEach(dd ->{
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);// 发货单主键
                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getOrderDetailId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量

                detailList.add(detail);
            });
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }
}
