/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String WZXT_CHECK = "WZXT_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() == null) {
            entity.setUseState(0);
        }
        super.saveOrUpdate((Object)entity, false);
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).querAnalysisList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(deliveryId);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)new LambdaQueryWrapper().eq(DeliveryDetailEntity::getDeliveryId, (Object)delivery.getId()));
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            ArrayList detailList = new ArrayList();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);
                detail.setDeliveryDetailId(dd.getId());
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getOrderDetailId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }
}

