/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public DeliveryVO queryDetails(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.orderService.selectById(id));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        return deliveryVO;
    }

    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)deliveryVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_DELIVERY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                deliveryVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)deliveryVO, DeliveryEntity.class));
        List<DeliveryDetailEntity> planDetail = entity.getDeliveryDetail();
        String materialName = "";
        if (planDetail != null && planDetail.size() > 0) {
            for (DeliveryDetailEntity deliveryDetailEntity : planDetail) {
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.deliveryService.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

