/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WZXT_PURCHASE_BILL_CODE = "WZXT_PURCHASE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)orderVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                orderVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StringBuffer materialName = new StringBuffer();
        ArrayList listedit = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if (null != vo.getLeafFlag() && !vo.getLeafFlag().booleanValue()) {
                    materialName.append(vo.getMaterialName() + ",");
                }
                if (null == vo.getLeafFlag() || vo.getLeafFlag().booleanValue()) {
                    vo.setLeafFlag(Boolean.valueOf(true));
                    if (null != vo.getId()) {
                        if ("del".equals(vo.getRowState())) {
                            PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                            BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                            BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                            BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                            BigDecimal orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                            entity.setOccupyNums(occupyNums.subtract(orderNums));
                            entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                            listedit.add(entity);
                        } else {
                            BigDecimal orderNums;
                            OrderDetailEntity detailEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getId())));
                            BigDecimal orderNumsDb = detailEntity.getOrderNumsSum() == null ? BigDecimal.ZERO : detailEntity.getOrderNumsSum();
                            BigDecimal bigDecimal = orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                            if (orderNums.compareTo(orderNumsDb) != 0) {
                                BigDecimal surplusNums;
                                BigDecimal subtractNum = orderNumsDb.subtract(orderNums);
                                PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                                BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                                BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                                BigDecimal bigDecimal2 = surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                                if (surplusNums.add(subtractNum).compareTo(BigDecimal.ZERO) < 0) {
                                    throw new BusinessException("\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8ba1\u5212\u5269\u4f59\u91cf\uff0c\u8be5\u8ba1\u5212\u660e\u7ec6\u5b9e\u9645\u5269\u4f59\u91cf\u4e3a\u3010" + surplusNums + "\u3011!");
                                }
                                entity.setOccupyNums(occupyNums.subtract(subtractNum));
                                entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                                listedit.add(entity);
                            }
                        }
                    } else {
                        BigDecimal orderNums;
                        PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)this.planDetailService.getById(vo.getPlanDetailId())));
                        BigDecimal nums = entity.getNums() == null ? BigDecimal.ZERO : entity.getNums();
                        BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                        BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                        BigDecimal bigDecimal = orderNums = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                        if (surplusNums.subtract(orderNums).compareTo(BigDecimal.ZERO) < 0) {
                            throw new BusinessException("\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8ba1\u5212\u5269\u4f59\u91cf\uff0c\u8be5\u8ba1\u5212\u660e\u7ec6\u5b9e\u9645\u5269\u4f59\u91cf\u4e3a\u3010" + surplusNums + "\u3011!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        listedit.add(entity);
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(listedit)) {
                this.planDetailService.updateBatchById(listedit);
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            orderVO.setMaterialName(materialNames);
        }
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)orderVO, OrderEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public OrderVO updateReceived(OrderVO orderVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderVO.getId()));
        ArrayList entityList = new ArrayList();
        if (1 == orderVO.getReceiveState()) {
            orderVO.setReceiveState(Integer.valueOf(1));
            orderVO.setDeliverState(Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 1);
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(vo.getOrderNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                    vo.setUnDeliverNumsSum(vo.getOrderNumsSum());
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            orderVO.setReceiveState(Integer.valueOf(3));
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
                this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 3);
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(BigDecimal.ZERO);
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                    vo.setUnDeliverNumsSum(BigDecimal.ZERO);
                });
            }
        }
        orderVO.setBillState(orderEntity.getBillState());
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)orderVO, OrderEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return orderVO;
    }

    @Override
    public OrderVO updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderVO.getId()));
        orderVO.setReceiveState(Integer.valueOf(2));
        orderVO.setDeliverState(Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            this.OrderDetailBack(orderVO.getPurchaseOrderDetail(), 2);
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                vo.setDeliverNumsSum(BigDecimal.ZERO);
                vo.setUnDeliverNumsSum(vo.getReceiveNumsSum());
            });
        }
        orderVO.setBillState(orderEntity.getBillState());
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)orderVO, OrderEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
    }

    public void OrderDetailBack(List<OrderDetailVO> detailList, int type) {
        ArrayList entityList = new ArrayList();
        ArrayList planDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, (Object)vo.getTid());
                lambda.eq(OrderDetailEntity::getOrderId, (Object)vo.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                lambda.orderByAsc(BaseEntity::getId);
                List details = this.orderDetailService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    BigDecimal receiveNumsSum = BigDecimal.ZERO;
                    if (1 == type) {
                        receiveNumsSum = vo.getOrderNumsSum() == null ? BigDecimal.ZERO : vo.getOrderNumsSum();
                    } else if (2 == type) {
                        receiveNumsSum = vo.getReceiveNumsSum() == null ? BigDecimal.ZERO : vo.getReceiveNumsSum();
                    }
                    for (int i = 0; i < details.size(); ++i) {
                        BigDecimal nums;
                        BigDecimal occupyNums;
                        PlanDetailEntity planDetailEntity;
                        BigDecimal orderNumsSum;
                        BigDecimal bigDecimal = orderNumsSum = ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum() == null ? BigDecimal.ZERO : ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum();
                        if (receiveNumsSum.compareTo(BigDecimal.ZERO) > 0) {
                            if (receiveNumsSum.compareTo(orderNumsSum) >= 0) {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            } else {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(receiveNumsSum);
                                planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                                occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                                nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));
                            continue;
                        }
                        planDetailEntity = (PlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getPlanDetailId())));
                        occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                        nums = planDetailEntity.getNums() == null ? BigDecimal.ZERO : planDetailEntity.getNums();
                        planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));
                        planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                        planDetailList.add(planDetailEntity);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                        this.orderDetailService.updateBatchById(entityList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)planDetailList)) {
                        this.planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }

    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)super.selectById((Serializable)id));
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        ArrayList listres = new ArrayList();
        List list = orderVO.getPurchaseOrderDetail();
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if (vo.getParentId().equals(999L)) {
                    listres.add(vo);
                }
            });
            listres.forEach(vo -> {
                ArrayList listd = new ArrayList();
                list.forEach(e -> {
                    if (vo.getTid().equals(e.getParentId())) {
                        listd.add(e);
                    }
                });
                vo.setChildren(listd);
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        return orderVO;
    }

    @Override
    public List<OrderVO> queryUnDeliverList(Page<OrderVO> page, QueryWrapper queryWrapper) {
        List<OrderVO> list = ((OrderMapper)this.baseMapper).queryUnDelivers(page, queryWrapper);
        return list;
    }
}

