package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.service.IDeliveryService;

import javax.servlet.http.HttpServletResponse;

/**
 * 发货实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("delivery")
public class DeliveryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrgApi orgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveorUpdateVO) {
        return deliveryService.saveOrUpdate(saveorUpdateVO);
    }

    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
    	DeliveryEntity entity = deliveryService.selectById(id);
    	DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 确认发货
     * @param id
     */
    @RequestMapping(value = "/deliver", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> deliver(Long id) {
        return deliveryService.deliver(id);
    }
    /**
     * 根据订单主键查询,返回发货信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetails(@RequestParam Long id) {
        DeliveryVO vo = deliveryService.queryDetails(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        deliveryService.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DeliveryEntity> page = deliveryService.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(null!=page.getRecords()&&CollectionUtils.isNotEmpty(page.getRecords())){
            List<DeliveryVO> DeliveryVOList = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
            DeliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("已发货");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
            pageData.setRecords(DeliveryVOList);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表-移动端但验收单
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCheckList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryCheckList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("deliver_state",new Parameter("eq",1));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DeliveryEntity> page = deliveryService.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(null!=page.getRecords()&&CollectionUtils.isNotEmpty(page.getRecords())){
            List<DeliveryVO> DeliveryVOList = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
            DeliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("待验收");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
            pageData.setRecords(DeliveryVOList);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("已发货分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<DeliveryEntity> pageData= deliveryService.queryPage(param,false);
        List<DeliveryVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(),DeliveryVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //发货状态（0-自由态，1-已发货，2-已验收）
                if (vo.getDeliverState() == 0){
                    vo.setDeliverStateName("自由态");
                }
                if (vo.getDeliverState() == 1){
                    vo.setDeliverStateName("已发货");
                }
                if (vo.getDeliverState() == 2){
                    vo.setDeliverStateName("已验收");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("deliveryExport.xlsx", beans, response);
    }

}
