package com.ejianc.business.wzxt.controller.api;

import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.InstoreDetailVO;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/check/")
public class CheckApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICheckService checkService;

	@Autowired
	private ICheckDetailService checkDetailService;
	
	@RequestMapping(value = "updateUseState", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Boolean> updateUseState(
			@RequestParam(value="checkId", required=true) Long checkId,
			@RequestParam(value="useState", required=false) Integer useState) {
		CheckEntity entity = checkService.selectById(checkId);
		entity.setUseState(useState);
		return CommonResponse.success(checkService.updateById(entity));
	}

	@RequestMapping(value = "updateInstoreNum", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Boolean> updateInstoreNum(@RequestBody InstoreVO instoreVO) {
		CheckEntity entity = checkService.selectById(instoreVO.getCheckId());
		entity.setInstoreId(instoreVO.getInstoreId());
		checkService.updateById(entity);
		List<InstoreDetailVO> vos = instoreVO.getDetailList();
		if(CollectionUtils.isNotEmpty(vos)){
			List<CheckDetailEntity> list = new ArrayList<>();
			vos.forEach(vo ->{
				CheckDetailEntity detail = checkDetailService.getById(vo.getCheckDetailId());
				BigDecimal instoreNum = detail.getInstoreNum()==null?BigDecimal.ZERO:detail.getInstoreNum();// 入库单数量
				detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
				detail.setInstoreId(vo.getInstoreId());
				detail.setInstoreDetailId(vo.getInstoreDetailId());
				list.add(detail);
			});
			if(CollectionUtils.isNotEmpty(list)){
				checkDetailService.updateBatchById(list);
			}
		}
		return CommonResponse.success(true);
	}

}
