/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/check/"})
public class CheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    @RequestMapping(value={"updateUseState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> updateUseState(@RequestParam(value="checkId", required=true) Long checkId, @RequestParam(value="useState", required=false) Integer useState) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(checkId));
        entity.setUseState(useState);
        return CommonResponse.success((Object)this.checkService.updateById((Object)entity));
    }

    @RequestMapping(value={"updateInstoreNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateInstoreNum(@RequestBody InstoreVO instoreVO) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(instoreVO.getCheckId()));
        entity.setInstoreId(instoreVO.getInstoreId());
        this.checkService.updateById((Object)entity);
        List vos = instoreVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            ArrayList list = new ArrayList();
            vos.forEach(vo -> {
                CheckDetailEntity detail = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getCheckDetailId())));
                BigDecimal instoreNum = detail.getInstoreNum() == null ? BigDecimal.ZERO : detail.getInstoreNum();
                detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
                detail.setInstoreId(vo.getInstoreId());
                detail.setInstoreDetailId(vo.getInstoreDetailId());
                list.add(detail);
            });
            if (CollectionUtils.isNotEmpty(list)) {
                this.checkDetailService.updateBatchById(list);
            }
        }
        return CommonResponse.success((Object)true);
    }
}

