/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public DeliveryVO queryDetails(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.orderService.selectById(id));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        return deliveryVO;
    }

    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)deliveryVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_DELIVERY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                deliveryVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)deliveryVO, DeliveryEntity.class));
        List<DeliveryDetailEntity> deliveryDetail = entity.getDeliveryDetail();
        String materialName = "";
        if (deliveryDetail != null && deliveryDetail.size() > 0) {
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetail) {
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.deliveryService.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<DeliveryVO> deliver(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(DeliveryEntity::getBillState, (Object)1);
        updateWrapper.set(DeliveryEntity::getDeliverState, (Object)1);
        boolean flag = this.deliveryService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)id);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0) {
            ArrayList<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
            queryWrapperOrderDetail.in(BaseEntity::getId, orderDetailIdList);
            List orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList) {
                    if (!deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())) continue;
                    orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                }
            }
            boolean flagOrder = this.orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u53d1\u8d27\u6210\u529f\uff01", (Object)vo);
    }
}

