/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.CheckRestVO;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/check/"})
public class CheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    @RequestMapping(value={"queryCheckRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckRestVO>> queryCheckRef(@RequestParam(value="projectSourceId", required=false) String projectSourceId) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((String)projectSourceId)) {
            param.getParams().put("projectSourceId", new Parameter("eq", (Object)projectSourceId));
        }
        param.getParams().put("saveState", new Parameter("eq", (Object)1));
        param.getParams().put("useState", new Parameter("ne", (Object)1));
        param.getOrderMap().put("checkDate", "desc");
        IPage page = this.checkService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List entityList = page.getRecords();
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                CheckEntity data = (CheckEntity)((Object)((Object)this.checkService.selectById(entity.getId())));
                list.add(data);
            });
        }
        pageData.setRecords(BeanMapper.mapList(list, CheckRestVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"updateUseState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateUseState(@RequestParam(value="checkIds", required=true) List<Long> checkIds, @RequestParam(value="useState", required=false) Integer useState) {
        if (CollectionUtils.isNotEmpty(checkIds)) {
            ArrayList editlist = new ArrayList();
            checkIds.forEach(checkId -> {
                CheckEntity entity = (CheckEntity)((Object)((Object)this.checkService.selectById((Serializable)checkId)));
                entity.setUseState(useState);
                editlist.add(entity);
            });
            if (CollectionUtils.isNotEmpty(editlist)) {
                return CommonResponse.success((Object)this.checkService.updateBatchById(editlist));
            }
        }
        return CommonResponse.success((Object)true);
    }

    @RequestMapping(value={"updateInstoreNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateInstoreNum(@RequestBody List<InstoreVO> instoreVOList) {
        if (CollectionUtils.isNotEmpty(instoreVOList)) {
            ArrayList editlist = new ArrayList();
            instoreVOList.forEach(instoreVO -> {
                CheckEntity entity = (CheckEntity)((Object)((Object)this.checkService.selectById(instoreVO.getCheckId())));
                entity.setInstoreId(instoreVO.getInstoreId());
                editlist.add(entity);
            });
            if (CollectionUtils.isNotEmpty(editlist)) {
                this.checkService.updateBatchById(editlist);
            }
            instoreVOList.forEach(instoreVO -> {
                List vos = instoreVO.getDetailList();
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    ArrayList list = new ArrayList();
                    vos.forEach(vo -> {
                        CheckDetailEntity detail = (CheckDetailEntity)((Object)((Object)((Object)this.checkDetailService.getById(vo.getCheckDetailId()))));
                        BigDecimal instoreNum = detail.getInstoreNum() == null ? BigDecimal.ZERO : detail.getInstoreNum();
                        detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
                        detail.setInstoreId(vo.getInstoreId());
                        detail.setInstoreDetailId(vo.getInstoreDetailId());
                        list.add(detail);
                    });
                    if (CollectionUtils.isNotEmpty(list)) {
                        this.checkDetailService.updateBatchById(list);
                    }
                }
            });
        }
        return CommonResponse.success((Object)true);
    }
}

