/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"delivery"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveorUpdateVO) {
        return this.deliveryService.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/deliver"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> deliver(Long id) {
        return this.deliveryService.deliver(id);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetails(@RequestParam Long id) {
        DeliveryVO vo = this.deliveryService.queryDetails(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        this.deliveryService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse childProResp = this.projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if (!childProResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)childProResp.getData()))) {
            childIds.addAll(((List)childProResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter("in", childIds));
            }
        }
        IPage page = this.deliveryService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (null != page.getRecords() && CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List DeliveryVOList = BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class);
            DeliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getDeliverState() == 0) {
                    vo.setDeliverStateName("\u81ea\u7531\u6001");
                }
                if (vo.getDeliverState() == 1) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                }
                if (vo.getDeliverState() == 2) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
            pageData.setRecords(DeliveryVOList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryCheckList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryCheckList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        param.getParams().put("deliver_state", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.deliveryService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (null != page.getRecords() && CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List DeliveryVOList = BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class);
            DeliveryVOList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getDeliverState() == 0) {
                    vo.setDeliverStateName("\u81ea\u7531\u6001");
                }
                if (vo.getDeliverState() == 1) {
                    vo.setDeliverStateName("\u5f85\u9a8c\u6536");
                }
                if (vo.getDeliverState() == 2) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
            pageData.setRecords(DeliveryVOList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("linkName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage pageData = this.deliveryService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), DeliveryVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getDeliverState() == 0) {
                    vo.setDeliverStateName("\u81ea\u7531\u6001");
                }
                if (vo.getDeliverState() == 1) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                }
                if (vo.getDeliverState() == 2) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("deliveryExport.xlsx", beans, response);
    }
}

