package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("order") 
public class OrderBpmServiceImpl implements ICommonBusinessService {

	@Value("${common.env.base-host}")
	private String baseHost;

	@Value("${weChat.templateid}")
	private String templateid;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOrderService orderService;

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OrderEntity orderEntity = orderService.selectById(billId);
		orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		orderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = orderService.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
			orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		}
		orderEntity.setReceiveState(0);
		orderService.saveOrUpdate(orderEntity,false);

		CommonResponse<List<UserVO>> childUserResp = wzxtUserProjectRelationApi.queryUserByProjectAndTenant(orderEntity.getProjectId(),orderEntity.getSupplierTenantId());
//
		if(childUserResp.isSuccess()) {
			// TO DO 定时到期下架消息发送
			List<String> messageType = new ArrayList<>();
			messageType.add("sys");
			messageType.add("weixin");
			List<String> sender = new ArrayList<>();
			sender.addAll(childUserResp.getData().stream().map(s -> String.valueOf(s.getId())).collect(Collectors.toList()));
			logger.info("发送信息给发布人:>----------" + sender+baseHost);
			String formurl = baseHost+"ejc-wzxt-frontend/#/orderList/unConfirmedCard?id="+billId;
			String subject = "您有一个物资订单【"+orderEntity.getProjectName()+"--"+orderEntity.getBillCode()+"】需要您及时处理。";
			String content = "您有一个物资订单【"+orderEntity.getProjectName()+"--"+orderEntity.getBillCode()+"】需要您及时处理。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
			this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getSupplierTenantId()),orderEntity);
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//		//是否被其他单据引用
//		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(res.isSuccess()) {//单据未被下游单据引用
//			return CommonResponse.success();
//		}else{
//			return CommonResponse.error(res.getMsg());
//		}
		return CommonResponse.error("采购订单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = orderService.selectById(billId);
		orderEntity.setReceiveState(null);
		orderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content ,String tenantId,OrderEntity orderEntity) {
		logger.info("发送消息开始！===========");
		PushMsgParameter parameter = new PushMsgParameter();
		List<String> channel = new ArrayList<>();
		if (messageType.contains("sys")) {
			// 系统消息
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
		}
		if (messageType.contains("smsg")) {
			// 短信消息
			// channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
		}
		if (messageType.contains("weChat")) {
			// 系统消息
			channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
		}
		if (messageType.contains("weixin")) {
			// 公众号消息
			channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
		}
		String[] receivers = user.toArray(new String[user.size()]);
		parameter.setReceivers(receivers);// 收信人
		parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
		parameter.setMsgType(msgType);
		parameter.setSubject(subject);// 标题
		parameter.setContent(content);// 内容
		parameter.setTenantId(tenantId);
		parameter.setSendUserId(InvocationInfoProxy.getUserid());

		//公众号消息
		if (messageType.contains("weixin")) {
			JSONObject weixinParams = new JSONObject();
			weixinParams.put("template_id", templateid);
			JSONObject wxparams = new JSONObject();
			wxparams.put("first", subject);
			wxparams.put("keyword1", DateFormater.getInstance().format(DateFormater.SHORT_FORMAT));
			wxparams.put("keyword2", orderEntity.getBillCode());
			wxparams.put("remark", "点击查看详情");
			weixinParams.put("data", wxparams);
			weixinParams.put("url", "https://www.baidu.com?openid={openid}");
			parameter.setWeixinParams(weixinParams);
		}

		try {
			CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
			if (result.isSuccess()) {
				logger.error("消息发送成功---------------->" + result.getMsg());
			} else {
				logger.error("消息发送失败---------------->" + result.getMsg());
			}
		} catch (Exception e) {
			logger.error("调用消息中心RPC服务异常--------------" + e);
		}
	}

}
