package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 发货实体
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${weChat.wzys-agentid}")
    private String wzysAgentid;

    @Value("${weChat.wzys-secret}")
    private String wzysSecret;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Override
    public DeliveryVO queryDetails(Long id) {

        OrderEntity entity = orderService.selectById(id);
        DeliveryVO deliveryVO = BeanMapper.map(entity, DeliveryVO.class);
        //新增逻辑处理
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        deliveryVO.setTenantId(entity.getSupplierTenantId());
        return deliveryVO;
    }
    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(deliveryVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_DELIVERY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                deliveryVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        DeliveryEntity entity = BeanMapper.map(deliveryVO, DeliveryEntity.class);
        //汇总物资明细名称
        List<DeliveryDetailEntity> deliveryDetail = entity.getDeliveryDetail();
        String materialName = "";
        if(deliveryDetail != null && deliveryDetail.size() > 0){
            for(DeliveryDetailEntity deliveryDetailEntity : deliveryDetail){
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        deliveryService.saveOrUpdate(entity, false);
        //计算未发货数量

        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<DeliveryVO> deliver(Long id) {
        //修改发货和单据状态
        LambdaUpdateWrapper<DeliveryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(DeliveryEntity::getId, id);
        updateWrapper.set(DeliveryEntity::getBillState, 1);
        updateWrapper.set(DeliveryEntity::getDeliverState, 1);
        boolean flag = deliveryService.update(updateWrapper);
        if (!flag){
            throw new BusinessException("网络异常，发货状态更新失败，请稍后再试");
        }

        //回写订单的发货单
        LambdaQueryWrapper<DeliveryDetailEntity> queryWrapperDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, id);
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0){
            List<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            //查询订单详情
            LambdaQueryWrapper<OrderDetailEntity> queryWrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
            queryWrapperOrderDetail.in(OrderDetailEntity::getId, orderDetailIdList);
            List<OrderDetailEntity> orderDetailEntityList = orderDetailService.list(queryWrapperOrderDetail);
            //回写发货单详情-发货量
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList){
                    if (deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())){
                        orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                    }
                }
            }
            //更新订单发货数量
            boolean flagOrder = orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder){
                throw new BusinessException("网络异常，发货数量更新失败，请稍后再试");
            }
            //回写订单状态
            DeliveryEntity entity = deliveryService.selectById(id);
            LambdaQueryWrapper<OrderDetailEntity> wrapperOrderDetail = Wrappers.<OrderDetailEntity>lambdaQuery();
            wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, entity.getOrderId());
            wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, false);
            List<OrderDetailEntity> orderDetailList = orderDetailService.list(wrapperOrderDetail);
            if (orderDetailList != null && orderDetailList.size() > 0){
                Boolean b = true;
                for (OrderDetailEntity orderDetailEntity : orderDetailList){
                    BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                    BigDecimal deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum();
                    if (receiveNumsSum.compareTo(deliverNumsSum) == 1){
                        b = false;
                    }
                }
                if (b){
                    //修改发货和单据状态
                    LambdaUpdateWrapper<OrderEntity> updateOrderWrapper = new LambdaUpdateWrapper<>();
                    updateOrderWrapper.eq(OrderEntity::getId, entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, 1);
                    boolean updateFlagOrder = orderService.update(updateOrderWrapper);
                    if (!updateFlagOrder){
                        throw new BusinessException("网络异常，订单发货状态更新失败，请稍后再试");
                    }
                }

            }
        }
        // TO DO 发货消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        DeliveryEntity entity = deliveryService.selectById(id);
        OrderEntity orderEntity = orderService.getById(entity.getOrderId());
        sender.add(String.valueOf(orderEntity.getCommitId()));
//        String formurl = baseHost+"ejc-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "您的订单【"+orderEntity.getProjectName()+"+"+orderEntity.getBillCode()+"】已发货，请及时验收!";
        String content = "您的订单【"+orderEntity.getProjectName()+"+"+orderEntity.getBillCode()+"】已发货，请到企业微信验收!";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()));
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("发货成功！",vo);
    }
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", wzysAgentid);
            weixineeParams.put("secret", wzysSecret);
            weixineeParams.put("content", subject);
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
