/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckRestVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService service;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveorUpdateVO) {
        saveorUpdateVO.setSaveState(Integer.valueOf(1));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/saveOrUpdateTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdateTemp(@RequestBody CheckVO saveorUpdateVO) {
        saveorUpdateVO.setSaveState(Integer.valueOf(0));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/deliveryToCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> deliveryToCheck(Long id) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.deliveryToCheck(id));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.deleteIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter("eq", (Object)1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (!param.getParams().containsKey("mobile")) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            param.getParams().remove("mobile");
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter("eq", (Object)1));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList commonOrgIds = new ArrayList();
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                String checkTypeName = "";
                if (vo.getCheckType().equals("1")) {
                    checkTypeName = "\u81ea\u8d2d\u6d88\u8017\u6750";
                } else if (vo.getCheckType().equals("2")) {
                    checkTypeName = "\u81ea\u8d2d\u5468\u8f6c\u6750";
                } else if (vo.getCheckType().equals("3")) {
                    checkTypeName = "\u79df\u8d41\u5468\u8f6c\u6750";
                } else if (vo.getCheckType().equals("4")) {
                    checkTypeName = "\u96f6\u661f\u91c7\u8d2d";
                }
                vo.setCheckTypeName(checkTypeName);
                String useStateName = "";
                useStateName = vo.getUseState() != null && vo.getUseState() == 1 ? "\u5df2\u5f15\u7528" : "\u672a\u5f15\u7528";
                vo.setUseStateName(useStateName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryTempList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryTempList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter("eq", (Object)0));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (!param.getParams().containsKey("mobile")) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            param.getParams().remove("mobile");
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getcount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<CheckVO>> response = this.queryTempList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((IPage)response.getData()).getTotal());
    }

    @RequestMapping(value={"/queryCheckedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryCheckedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkState", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAnalysisList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryAnalysisList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CheckAnalysisVO> list = this.service.querAnalysisList((Page<CheckAnalysisVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryLatelyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryLatelyDetail() {
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BaseEntity::getCreateUserCode, (Object)InvocationInfoProxy.getUsercode());
        lambda.orderByDesc(BaseEntity::getCreateTime);
        details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(details.get(0), CheckVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"queryCheckRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckRestVO>> queryCheckRef(@RequestParam(value="projectSourceId", required=false) String projectSourceId, @RequestParam(value="contractId", required=false) String contractId, @RequestParam(value="checkDate", required=false) String checkDate, @RequestParam(value="checkType", required=false) String checkType, @RequestParam(value="projectInstoreId", required=false) String projectInstoreId) {
        if (StringUtils.isEmpty((String)projectSourceId)) {
            throw new BusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u53c2\u7167\u5931\u8d25\uff0c\u6c34\u7535\u516b\u5c40\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectSourceId", new Parameter("eq", (Object)projectSourceId));
        if (StringUtils.isNotEmpty((String)contractId)) {
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        if (checkDate != null) {
            param.getParams().put("checkDate", new Parameter("le", (Object)checkDate));
        }
        if (checkType != null) {
            param.getParams().put("checkType", new Parameter("eq", (Object)checkType));
        }
        if (projectInstoreId != null) {
            param.getParams().put("projectInstoreId", new Parameter("eq", (Object)projectInstoreId));
        }
        param.getParams().put("saveState", new Parameter("eq", (Object)1));
        param.getParams().put("useState", new Parameter("ne", (Object)1));
        param.getOrderMap().put("checkDate", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List entityList = page.getRecords();
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                CheckEntity data = (CheckEntity)((Object)((Object)this.service.selectById(entity.getId())));
                list.add(data);
            });
        }
        pageData.setRecords(BeanMapper.mapList(list, CheckRestVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"updateUseState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateUseState(@RequestBody List<InstoreVO> instoreVOList) {
        if (CollectionUtils.isNotEmpty(instoreVOList)) {
            ArrayList editlist = new ArrayList();
            instoreVOList.forEach(instoreVO -> {
                CheckEntity entity = (CheckEntity)((Object)((Object)this.service.getById(instoreVO.getCheckId())));
                if (entity == null) {
                    this.logger.error("\u4fee\u6539\u5931\u8d25\uff01\u3010" + instoreVO.getCheckId() + "\u3011\u5355\u636e\u4e0d\u5b58\u5728\uff01");
                    return;
                }
                entity.setUseState(instoreVO.getUseState());
                editlist.add(entity);
            });
            if (CollectionUtils.isNotEmpty(editlist)) {
                return CommonResponse.success((Object)this.service.updateBatchById(editlist));
            }
        }
        return CommonResponse.success((Object)true);
    }

    @RequestMapping(value={"updateInstoreNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateInstoreNum(@RequestBody List<InstoreVO> instoreVOList) {
        if (CollectionUtils.isNotEmpty(instoreVOList)) {
            ArrayList editlist = new ArrayList();
            instoreVOList.forEach(instoreVO -> {
                CheckEntity entity = (CheckEntity)((Object)((Object)this.service.selectById(instoreVO.getCheckId())));
                entity.setInstoreId(instoreVO.getInstoreId());
                editlist.add(entity);
            });
            if (CollectionUtils.isNotEmpty(editlist)) {
                this.service.updateBatchById(editlist);
            }
            instoreVOList.forEach(instoreVO -> {
                List vos = instoreVO.getDetailList();
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    ArrayList list = new ArrayList();
                    vos.forEach(vo -> {
                        CheckDetailEntity detail = (CheckDetailEntity)((Object)((Object)((Object)this.checkDetailService.getById(vo.getCheckDetailId()))));
                        BigDecimal instoreNum = detail.getInstoreNum() == null ? BigDecimal.ZERO : detail.getInstoreNum();
                        detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
                        detail.setInstoreId(vo.getInstoreId());
                        detail.setInstoreDetailId(vo.getInstoreDetailId());
                        list.add(detail);
                    });
                    if (CollectionUtils.isNotEmpty(list)) {
                        this.checkDetailService.updateBatchById(list);
                    }
                }
            });
        }
        return CommonResponse.success((Object)true);
    }
}

