package com.ejianc.business.wzxt.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_plan")
public class PlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_name")
    private java.lang.String planName; // 使用计划名称
    @TableField(value="bill_code")
    private java.lang.String billCode; // 计划编码
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="plan_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planDate; // 计划使用日期
    @TableField(value="construction")
    private java.lang.String construction; // 施工部位
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 创建日期
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="planDetailService",pidName = "planId")
    private List<PlanDetailEntity> planDetail = new ArrayList<>();

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public List<PlanDetailEntity> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailEntity> planDetail) {
        this.planDetail = planDetail;
    }

    /**
     * 使用计划名称
     */
    public java.lang.String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(java.lang.String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 计划编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public java.util.Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(java.util.Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 施工部位
     */
    public java.lang.String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(java.lang.String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
}
