package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private static final String WZXT_CHECK = "WZXT_CHECK";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialApi materialApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveorUpdateVO, CheckEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 新增
        if(entity.getId() == null){
            entity.setUseState(0);// 未引用
            entity.setCheckState(1);// 已验收
        }
        // 验收人来源ID
        if(entity.getEmployeeId() != null){
            entity.setEmployeeSourceId(this.getUserSourceId(entity.getEmployeeId()));
        }
        // 物料明细
        List<CheckDetailEntity> detailList = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            // 物料名称
            List<Long> materialIds = detailList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> materialRes = materialApi.queryMaterialByIds(materialIds);
            if(!materialRes.isSuccess()){
                throw new BusinessException(materialRes.getCode(), materialRes.getMsg());
            }
            Map<Long, MaterialVO> materialVOMap = materialRes.getData().stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            StringBuffer materialName = new StringBuffer();
            detailList.forEach(detail ->{
                materialName.append(detail.getMaterialName()+",");
                if(materialVOMap.containsKey(detail.getMaterialId())){
                    MaterialVO materialVO = materialVOMap.get(detail.getMaterialId());
                    detail.setMaterialSourceId(materialVO.getSourceId());
                    detail.setMaterialTypeSourceId(materialVO.getCategorySourceId());
                    detail.setSystemId(materialVO.getSystemId());
                }
            });
            entity.setDetailList(detailList);
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
        }
        super.saveOrUpdate(entity, false);

        // 回写发货单验收状态及明细验收数量
        this.writeBackDelivery(saveorUpdateVO, true);
        // 回写订单验收状态及明细验收数量
        this.writeBackOrder(saveorUpdateVO, true);

        return BeanMapper.map(entity, CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return baseMapper.querAnalysisList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        vo.setProjectId(delivery.getProjectId());// 项目主键
        vo.setProjectSourceId(delivery.getProjectSourceId());// 项目来源id
        vo.setProjectName(delivery.getProjectName());// 项目名称
        vo.setOrgId(delivery.getOrgId());// 组织主键
        vo.setOrgName(delivery.getOrgName());// 组织名称
        vo.setContractId(delivery.getContractId());// 合同主键
        vo.setContractName(delivery.getContractName());// 合同名称
        vo.setSupplierId(delivery.getSupplierId());// 供方主键
        vo.setSupplierName(delivery.getSupplierName());// 供方名称
        vo.setSupplierTenantId(delivery.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(delivery.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(delivery.getMaterialName());// 物资名称
        vo.setOrderId(delivery.getOrderId());// 订单主键
        vo.setDeliveryId(deliveryId);// 发货单主键
        vo.setConstruction(delivery.getConstruction());// 使用部位
        // 发货单明细生成验收单明细
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(
                new LambdaQueryWrapper<DeliveryDetailEntity>().eq(DeliveryDetailEntity::getDeliveryId, delivery.getId()));
        if(CollectionUtils.isNotEmpty(deliveryDetailList)){
            List<CheckDetailVO> detailList = new ArrayList<>();
            deliveryDetailList.forEach(dd ->{
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);// 发货单主键
                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getOrderDetailId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量

                detailList.add(detail);
            });
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List<CheckEntity> entityList = baseMapper.selectList(new QueryWrapper<CheckEntity>().in("id", ids));
        if(CollectionUtils.isNotEmpty(entityList)){
            entityList.forEach(entity ->{
                if(entity.getUseState() == 1){
                    throw new BusinessException("单据已被引用，不允许删除！");
                }
            });
        }
        List<CheckVO> vos = BeanMapper.mapList(entityList, CheckVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(vo ->{
                // 回写发货单验收状态及明细验收数量
                this.writeBackDelivery(vo, false);
                // 回写订单验收状态及明细验收数量
                this.writeBackOrder(vo, false);
            });
        }
        return super.removeByIds(ids, true);
    }

    /**
     * 回写发货单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        // 回写验收状态
        if(checkVO.getDeliveryId() != null){
            if(null == checkVO.getId() || !flag){
                DeliveryEntity delivery = deliveryService.getById(checkVO.getDeliveryId());
                delivery.setDeliverState(flag ? 2 : 1);
                deliveryService.updateById(delivery);
            }
        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<DeliveryDetailEntity> ddEditList = new ArrayList<>();// 发货单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag){
                        // 新增或删除
                        DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                        BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                        ddCheckNums = flag ? ddCheckNums.add(checkNums) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(ddEditList)){
                deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    /**
     * 回写订单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        // 回写验收状态（暂不回写）
//        if(checkVO.getOrderId() != null){
//            if(null == checkVO.getId() || !flag){
//                OrderEntity order = orderService.getById(checkVO.getOrderId());
//                order.setDeliverState(flag ? 2 : 1);
//                orderService.updateById(order);
//            }
//        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<OrderDetailEntity> odEditList = new ArrayList<>();// 订单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getOrderDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag){
                        // 新增或删除
                        OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                        BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                        odCheckNums = flag ? odCheckNums.add(checkNums) : odCheckNums.subtract(checkNums);//例子  200 + 80
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(odEditList)){
                orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    /**
     * 获取用户sourceId
     * @return
     */
    private String getUserSourceId(Long userid) {
        CommonResponse<List<UserVO>> res = userApi.queryListByIds(new String[]{String.valueOf(userid)});
        if(!res.isSuccess()){
            throw new BusinessException("查询用户失败！");
        }
        if(CollectionUtils.isNotEmpty(res.getData())){
            UserVO vo = res.getData().get(0);// 获取用户VO
            if(vo != null && StringUtils.isNotEmpty(vo.getSourceId())){
                return vo.getSourceId();// 来源ID
            }
        }
        return null;
    }
}
