/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckDetailsVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String WZXT_CHECK = "WZXT_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        List<CheckDetailEntity> detailList;
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() == null) {
            entity.setUseState(0);
            entity.setCheckState(1);
        }
        if (entity.getEmployeeId() != null) {
            entity.setEmployeeSourceId(this.getUserSourceId(entity.getEmployeeId()));
        }
        if (CollectionUtils.isNotEmpty(detailList = entity.getDetailList())) {
            List materialIds = detailList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse materialRes = this.materialApi.queryMaterialByIds(materialIds);
            if (!materialRes.isSuccess()) {
                throw new BusinessException(Integer.valueOf(materialRes.getCode()), materialRes.getMsg());
            }
            Map materialVOMap = ((List)materialRes.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            StringBuffer materialName = new StringBuffer();
            detailList.forEach(detail -> {
                materialName.append(detail.getMaterialName() + ",");
                if (materialVOMap.containsKey(detail.getMaterialId())) {
                    MaterialVO materialVO = (MaterialVO)materialVOMap.get(detail.getMaterialId());
                    detail.setMaterialSourceId(materialVO.getSourceId());
                    detail.setMaterialTypeSourceId(materialVO.getCategorySourceId());
                    detail.setSystemId(materialVO.getSystemId());
                }
            });
            entity.setDetailList(detailList);
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
        }
        super.saveOrUpdate((Object)entity, false);
        this.writeBackDelivery(saveorUpdateVO, true);
        this.writeBackOrder(saveorUpdateVO, true);
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectSourceId(delivery.getProjectSourceId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(deliveryId);
        vo.setConstruction(delivery.getConstruction());
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)new LambdaQueryWrapper().eq(DeliveryDetailEntity::getDeliveryId, (Object)delivery.getId()));
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            ArrayList detailList = new ArrayList();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);
                detail.setDeliveryDetailId(dd.getId());
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getOrderDetailId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List vos;
        List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"id", ids));
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                if (entity.getUseState() == 1) {
                    throw new BusinessException("\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(vos = BeanMapper.mapList((Iterable)entityList, CheckVO.class)))) {
            vos.forEach(vo -> {
                this.writeBackDelivery((CheckVO)vo, false);
                this.writeBackOrder((CheckVO)vo, false);
            });
        }
        return super.removeByIds(ids, true);
    }

    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        if (!(checkVO.getDeliveryId() == null || null != checkVO.getId() && flag.booleanValue())) {
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(checkVO.getDeliveryId()));
            delivery.setDeliverState(flag != false ? 2 : 1);
            this.deliveryService.updateById((Object)delivery);
        }
        List detailList = checkVO.getDetailList();
        ArrayList ddEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || vo.getRowState().equals("del")) {
                        BigDecimal ddCheckNums;
                        DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                        BigDecimal bigDecimal2 = ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                        ddCheckNums = flag.booleanValue() ? (vo.getRowState().equals("del") ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums)) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(ddEditList)) {
                this.deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        List detailList = checkVO.getDetailList();
        ArrayList odEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getOrderDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || vo.getRowState().equals("del")) {
                        BigDecimal odCheckNums;
                        OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                        BigDecimal bigDecimal2 = odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                        odCheckNums = flag.booleanValue() ? (vo.getRowState().equals("del") ? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums)) : odCheckNums.subtract(checkNums);
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(odEditList)) {
                this.orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    private String getUserSourceId(Long userid) {
        UserVO vo;
        CommonResponse res = this.userApi.queryListByIds(new String[]{String.valueOf(userid)});
        if (!res.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)res.getData())) && (vo = (UserVO)((List)res.getData()).get(0)) != null && StringUtils.isNotEmpty((CharSequence)vo.getSourceId())) {
            return vo.getSourceId();
        }
        return null;
    }
}

