package com.ejianc.business.wzxt.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataTransfor.service.ISdbjDataTransforService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;

@Service("planSdbjDataTransforService") 
public class PlanSdbjDataTransforServiceImpl implements ISdbjDataTransforService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String REFER_CACHE_KEY = "refer_cache_key:";

    @Autowired
    private IPlanService planService;
	
	@Value("${common.env.base-host}")
	private String baseHost; 
	@Autowired
	private IAttachmentApi attachmentApi;
	
	/**
	 * 水电八局数据转换
	 * 
	 * @param billId
	 * @param billTypeCode
	 * @return
	 */
	@Override
	public CommonResponse<String> dataTransfor(Map<String,Object> params) {
		if(params.get("billId")==null){
			throw new BusinessException("缺少单据id");
		}
		if(params.get("billTypeCode")==null){
			throw new BusinessException("缺少单据类型编码");
		}
		Long billId = Long.parseLong(params.get("billId").toString());
		String billTypeCode = params.get("billTypeCode").toString();
		PlanEntity entity = planService.selectById(billId);
		if(entity == null){
			return CommonResponse.error("未获取到单据："+billId+"信息");
		}

		JSONObject json = new JSONObject();

		json.put("fdProjectName", entity.getProjectName());//所属项目
		json.put("fdPlanName", entity.getPlanName());//使用计划名称
		json.put("fdPlanDate", entity.getPlanDate());//计划使用日期
		json.put("fdPlanSite", entity.getConstruction());//使用部位
		json.put("fdCompiler", entity.getEmployeeName());//编制人
		String createDate = "";
		if(entity.getUpdateTime()!=null){
			createDate = new SimpleDateFormat("yyyy-MM-dd").format(entity.getCreateDate());
		}
		json.put("fdDompilerDate", createDate);//编制日期
		
		List<String> fdMmNoList = new ArrayList<>();
		List<String> fdMmCategoryList = new ArrayList<>();
		List<String> fdMmNameList = new ArrayList<>();
		List<String> fdSpecificationList = new ArrayList<>();
		List<String> fdUnitList = new ArrayList<>();
		List<String> fdAuditQuantityList = new ArrayList<>();
		List<String> fdDemandQuantityList = new ArrayList<>();
		List<String> fdRemarksList = new ArrayList<>();
		CommonResponse<List<AttachmentVO>> attachmentlistResponse = attachmentApi.queryListBySourceId(entity.getId(), "BT200918000000001", "planBill002", null);
		if(attachmentlistResponse.isSuccess()&&attachmentlistResponse.getData().size()>0){
			List<AttachmentVO> attachmentlist = attachmentlistResponse.getData();
			String fdAttachment = "";
			for(AttachmentVO vo : attachmentlist){
				if(fdAttachment.length()>0){
					fdAttachment += (",<a href="+'"'+baseHost+"ejc-file-web/onlinePreview?fileId="+vo.getId()+'"'+ ">"+vo.getFileName()+"</a>");
				}else{
					fdAttachment += ("<a href="+'"'+baseHost+"ejc-file-web/onlinePreview?fileId="+vo.getId()+'"'+ ">"+vo.getFileName()+"</a>");
				}
			}
			json.put("fdAttachment", fdAttachment);//附件
		}
//		计划明细：fdDetail
		List<PlanDetailEntity> planDetail = entity.getPlanDetail();
		for(PlanDetailEntity item : planDetail){
			fdMmNoList.add(item.getMaterialCode());
			fdMmCategoryList.add(item.getMaterialTypeName());
			fdMmNameList.add(item.getMaterialName());
			fdSpecificationList.add(item.getSpec());
			fdUnitList.add(item.getUnit());
			fdAuditQuantityList.add(item.getNums().toString());
			fdDemandQuantityList.add(item.getPlanNum().toString());
			fdRemarksList.add(item.getMemo());
			
		}
		JSONObject fdDetail = new JSONObject();
		fdDetail.put("fdDetail.fdDemandQuantity", fdDemandQuantityList);
		fdDetail.put("fdDetail.fdUnit", fdUnitList);
		fdDetail.put("fdDetail.fdRemarks", fdRemarksList);
		fdDetail.put("fdDetail.fdAuditQuantity", fdAuditQuantityList);
		fdDetail.put("fdDetail.fdMmName", fdMmNameList);
		fdDetail.put("fdDetail.fdMmCategory", fdMmCategoryList);
		fdDetail.put("fdDetail.fdMmNo", fdMmNoList);
		fdDetail.put("fdDetail.fdSpecification", fdSpecificationList);
		json.put("fdDetail", fdDetail);

		json.put("fdCreator", getUserName(entity.getCreateUserCode()));//创建人
		String createTime = "";
		if(entity.getCreateTime()!=null){
			createTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getCreateTime());
		}
		json.put("fdCreateTime", createTime);//创建时间
		json.put("fdAltor", getUserName(entity.getUpdateUserCode()));//修改人
		String updateTime = "";
		if(entity.getUpdateTime()!=null){
			updateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getUpdateTime());
		}
		json.put("fdAlterTime", updateTime);//修改时间
		return CommonResponse.success("数据转换成功",json.toJSONString());
	}

	@SuppressWarnings("unchecked")
	public static String getUserName(String userCode) {
		try{
			MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
			if(StringUtils.isNotBlank(userCode) && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
				String cacheKey = REFER_CACHE_KEY + "idm-employee:" + userCode;
				RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
				
				Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
				
				JSONObject jsonObject = null;
				if (cacheValue != null) {
					jsonObject = JSON.parseObject(cacheValue.toString());
				} else {
					String referData = getReferRestUrl("idm-employee");
					JSONObject json = JSON.parseObject(referData);
					String referUrl = json.get("projectName").toString();
					Map<String, Object> reflist = new HashMap<>();
					reflist = (Map<String, Object>) json.get("refMapList");
					reflist.put("userCode", userCode);
					String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
					String jsonbackstr = null;
					try {
						jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
					} catch (Exception e) {}
					if(StringUtils.isNotBlank(jsonbackstr)) {
						jsonObject = JSON.parseObject(jsonbackstr);
						redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 5, TimeUnit.DAYS);
					}
				}
				if(jsonObject != null) {
					return jsonObject.getString("userName");
				}
			}
		}catch(Exception e) {}
		return userCode;
	}
	
	/**
	 * 通过元数据服务获取实体信息
	 * 
	 * @param className
	 * @return
	 */
	private static String getReferRestUrl(String referCode) {
		String data = null;
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		String backData = null;
		try {
			backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
		} catch (Exception e) {}

		JSONObject jsonobject = JSON.parseObject(backData);
		if(jsonobject.getString("code").equals("0")){
			if(jsonobject.getString("data")!=null){
				data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
			}
		}else{
			ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
		}
		return data;

	}
}
