package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.business.wzxt.vo.PmDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";
    @Autowired
    private CacheManager cacheManager;

    @Value("${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;

    @Value("${sdbj.appid}")
    private String APPID;
    @Value("${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;

    private static final String WZXT_PLAN_BILL_CODE = "WZXT_PLAN";

    private static final String PM_SUBJECT_LIST_URL = "slsd8j/openapi/MaterialOut_getPmSubjectList.action";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(planVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                planVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        PlanEntity entity = BeanMapper.map(planVO, PlanEntity.class);

        if(entity.getMaterialVerification()&&StringUtils.isNotEmpty(entity.getConstructionId())){
            //todo 校验数量是否超累计使用量
            //1,根据项目+材料主键  获取pm量
            Map<String, Object> param = new HashMap<>();
            Map<String, Object> data = new HashMap<>();
            List<String> pks = entity.getPlanDetail().stream().map(PlanDetailEntity::getMaterialSourceId).collect(Collectors.toList());
            data.put("projectid", entity.getProjectSourceId()); //八局项目Id
            data.put("materialidlist", pks); //材料Id
            param.put("data", data);
            CommonResponse<JSONObject> response = null;
            try {
                response = sendPostReq(PM_SUBJECT_LIST_URL, JSON.toJSONString(param));
                if(!response.isSuccess()) {
                    return CommonResponse.error("查询水电八局材料需求总预算接口失败，" + response.getMsg());
                }
            } catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error("查询水电八局材料需求总预算接口失败");
            }
            List<PmDetailVO> planDetailEntityList = (List<PmDetailVO>)response.getData();
            //2，查询该项目下所有审批通过的计划  根据材料主键+部位主键  group by
            List<PlanDetailVO> listDetials = baseMapper.queryDetails(entity.getProjectId());
            if(CollectionUtils.isNotEmpty(listDetials)){
                listDetials.forEach(e->{
                    if(CollectionUtils.isNotEmpty(planDetailEntityList)){
                        planDetailEntityList.forEach(k->{
                            if(e.getConstructionId().equals(k.getPartsID())&&e.getMaterialSourceId().equals(k.getMaterialId())){
                                k.setPlanNum(e.getNums());
                            }
                        });
                    }
                });
            }
        }

        //汇总物资明细名称
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if(planDetail != null && planDetail.size() > 0){
            for(PlanDetailEntity applyDetailEntity : planDetail){
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";

                if (applyDetailEntity.getNums() != null){
                    BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                    BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                    BigDecimal surplusNums = nums.subtract(occupyNums);
                    applyDetailEntity.setSurplusNums(surplusNums);
                    applyDetailEntity.setOccupyNums(occupyNums);
                    applyDetailEntity.setNums(nums);
                }
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        planService.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId,QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }


    private CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL+url;
        String reqResp =  HttpTookit.postByJson(newUrl, paramJson, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, paramJson, headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData.getJSONObject("data"));
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = SDBJ_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String reqUrl = SDBJ_SERVER_URL + ACCESS_TOKEN_URL;

        String tokenInfo = cacheManager.get(key);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject(tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get("invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if(invalidateTime > curTime) {
                return tokenData;
            }
        }

        Map<String, Object> params = new HashMap<>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader(reqUrl, params);
            logger.info("获取水电八局服务访问Token服务-[地址：{}, 参数：{}]，返回结果：{}", reqUrl, JSONObject.toJSONString(params), reqRespStr);

            JSONObject reqResp = JSONObject.parseObject(reqRespStr);
            if(BooleanUtils.isNotTrue((Boolean) reqResp.get("success"))) {
                logger.error(null != reqResp.get("message") ? reqResp.get("message").toString() : "获取水电八局服务请求Token失败！");
                return null;
            }

            Map<String, Object> tokenData = (Map<String, Object>) reqResp.get("data");
            JSONObject invalidateInfo = (JSONObject) tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get("time").toString());

            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", invalidateTime);

            //放入缓存，有效时间1小时
            cacheManager.setex(key, JSONObject.toJSONString(resp), 60 * 50);

            return resp;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }
}
