package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.foundation.wzxtUserProject.vo.WzxtUserProjectRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("purchaseOrder")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOrderService service;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description queryDetail 登录人获取 最近一次项目等信息
     * @param
     */
    @RequestMapping(value = "/queryLatelyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryLinkDetail() {
        List<OrderEntity> details = null;
        LambdaQueryWrapper<OrderEntity> lambda = Wrappers.<OrderEntity>lambdaQuery();
        lambda.eq(OrderEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(OrderEntity::getEmployeeId,InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(OrderEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0),OrderVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            List<PlanDetailEntity> listedit = new ArrayList<>();
            vos.forEach(vo ->{
                List<OrderDetailEntity> details = null;
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getOrderId,vo.getId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                details = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    details.forEach(e ->{
                        //说明是子集删除
                        PlanDetailEntity entity = planDetailService.getById(e.getPlanDetailId());
                        BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                        BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                        BigDecimal orderNums = e.getOrderNumsSum()==null?BigDecimal.ZERO:e.getOrderNumsSum();
                        entity.setOccupyNums(occupyNums.subtract(orderNums));
                        entity.setSurplusNums(surplusNums.add(orderNums));
                        listedit.add(entity);
                    });
                }

            });
            if(CollectionUtils.isNotEmpty(listedit)){
                planDetailService.updateBatchById(listedit);
            }
        }

        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("mobile");
        logger.info("前端标识----"+mobile);
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }else{
            logger.info("走移动端权限接口----");
            param.getParams().remove("mobile");
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            logger.info("获取到用户权限接口----"+childOrgResp.getData());
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }
            });
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnConfirmedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnconfirmedList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("supplierTenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 状态为待确认 */
        param.getParams().put("receiveState", new Parameter(QueryParam.EQ, 0));
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        CommonResponse<List<ProjectRegisterVO>> childProResp = projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if(!childProResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(childProResp.getData())){
            childIds.addAll(childProResp.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }

            });
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryDetail 供方查询详情
     * @param id
     */
    @RequestMapping(value = "/querySupplierDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> querySupplierDetail(Long id) {
        OrderEntity entity = service.selectById(id);
        if(1!=entity.getBillState()&&3!=entity.getBillState()){
            return CommonResponse.error("该订单已被撤回！");
        }
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);
        List<OrderDetailVO> listres = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(!vo.getLeafFlag()){
                    listres.add(vo);
                }
                // to do
                BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//接收数量
                BigDecimal deliverNumsSum = vo.getDeliverNumsSum()==null?BigDecimal.ZERO:vo.getDeliverNumsSum();//发货数量
                vo.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));//未发货数量
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        orderVO.setBillState(0);
        return CommonResponse.success("查询详情数据成功！",orderVO);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnDeliverList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnDeliverList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("supplierTenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<ProjectRegisterVO>> childProResp = projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if(!childProResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(childProResp.getData())){
            childIds.addAll(childProResp.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, childIds));
            }
        }
        Page<OrderVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<OrderVO> list = service.queryUnDeliverList(page,wrapper);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, OrderVO.class));
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }
            });
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  更新接收状态
     */
    @RequestMapping(value = "/updateReceived", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！",service.updateReceived(saveorUpdateVO));
    }

    /**
     * @Description  部分接收
     */
    @RequestMapping(value = "/updateReceivedPart", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceivedPart(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！",service.updateReceivedPart(saveorUpdateVO));
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        List<OrderVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
                if(null!=vo.getReceiveState()&&0==vo.getReceiveState()){
                    vo.setReceiveStateName("待确认");
                }else if(null!=vo.getReceiveState()&&1==vo.getReceiveState()){
                    vo.setReceiveStateName("全部接收");
                }else if(null!=vo.getReceiveState()&&2==vo.getReceiveState()){
                    vo.setReceiveStateName("部分接收");
                }else if(null!=vo.getReceiveState()&&3==vo.getReceiveState()){
                    vo.setReceiveStateName("已拒绝");
                }
                // 发货状态（0-待发货，1-已发货，2-已验收）
                if(null!=vo.getDeliverState()&&0==vo.getDeliverState()){
                    vo.setDeliverStateName("待发货");
                }else if(null!=vo.getDeliverState()&&1==vo.getDeliverState()){
                    vo.setDeliverStateName("已发货");
                }else if(null!=vo.getDeliverState()&&2==vo.getDeliverState()){
                    vo.setDeliverStateName("已验收");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("orderExport.xlsx", beans, response);
    }





}
