package com.ejianc.business.wzxt.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_plan")
public class PlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_name")
    private String planName; // 使用计划名称
    @TableField(value="bill_code")
    private String billCode; // 计划编码
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="plan_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划使用日期
    @TableField(value="material_verification")
    private Boolean materialVerification; // 是否使用材料核销
    @TableField(value="construction_id")
    private String constructionId; // 施工部位主键
    @TableField(value="construction")
    private String construction; // 施工部位
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 创建日期
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源id
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="planDetailService",pidName = "planId")
    private List<PlanDetailEntity> planDetail = new ArrayList<>();

    public String getConstructionId() {
        return constructionId;
    }

    public void setConstructionId(String constructionId) {
        this.constructionId = constructionId;
    }

    public Boolean getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Boolean materialVerification) {
        this.materialVerification = materialVerification;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public List<PlanDetailEntity> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailEntity> planDetail) {
        this.planDetail = planDetail;
    }

    /**
     * 使用计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 计划编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
