package com.ejianc.business.wzxt.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yqls
 * @date 2023-03-01 14:15:07
 */
@Component
public class ThirdSystemUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";

    @Autowired
    private CacheManager cacheManager;

    @Value("${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;

    @Value("${sdbj.appid}")
    private String APPID;

    @Value("${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;

    public CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();

        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL + url;
        String reqResp =  HttpTookit.get(newUrl, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL + url;
        String reqResp =  HttpTookit.postByJson(newUrl, paramJson, headers, 10000, 20000);
        logger.info("发送post请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, paramJson, headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData.getJSONObject("data"));
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = SDBJ_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String reqUrl = SDBJ_SERVER_URL + ACCESS_TOKEN_URL;

        String tokenInfo = cacheManager.get(key);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject(tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get("invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if(invalidateTime > curTime) {
                return tokenData;
            }
        }

        Map<String, Object> params = new HashMap<>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader(reqUrl, params);
            logger.info("获取水电八局服务访问Token服务-[地址：{}, 参数：{}]，返回结果：{}", reqUrl, JSONObject.toJSONString(params), reqRespStr);

            JSONObject reqResp = JSONObject.parseObject(reqRespStr);
            if(BooleanUtils.isNotTrue((Boolean) reqResp.get("success"))) {
                logger.error(null != reqResp.get("message") ? reqResp.get("message").toString() : "获取水电八局服务请求Token失败！");
                return null;
            }

            Map<String, Object> tokenData = (Map<String, Object>) reqResp.get("data");
            JSONObject invalidateInfo = (JSONObject) tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get("time").toString());

            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", invalidateTime);

            //放入缓存，有效时间1小时
            cacheManager.setex(key, JSONObject.toJSONString(resp), 60 * 50);

            return resp;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }
}
