/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weChat.templateid}")
    private String templateid;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        }
        orderEntity.setReceiveState(0);
        CommonResponse childUserResp = this.wzxtUserProjectRelationApi.queryUserByProjectAndTenant(orderEntity.getProjectId(), orderEntity.getSupplierTenantId());
        if (childUserResp.isSuccess()) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            messageType.add("weixin");
            ArrayList<String> sender = new ArrayList<String>();
            sender.addAll(((List)childUserResp.getData()).stream().map(s -> String.valueOf(s.getId())).collect(Collectors.toList()));
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
            String formurl = this.baseHost + "ejc-wzxt-frontend/#/orderList/unConfirmedCard?id=" + billId;
            String subject = "\u60a8\u6709\u4e00\u4e2a\u7269\u8d44\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u60a8\u53ca\u65f6\u5904\u7406\u3002";
            String content = "\u60a8\u6709\u4e00\u4e2a\u7269\u8d44\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u60a8\u53ca\u65f6\u5904\u7406\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getSupplierTenantId()), orderEntity);
        }
        if (null != orderEntity.getAutomaticWeigh() && 0 == orderEntity.getAutomaticWeigh()) {
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)orderEntity), DeliveryThirdVO.class);
            thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress() == null ? "/" : orderEntity.getOrderAddress());
            thirdVO.setCustomerName(orderEntity.getProjectName());
            thirdVO.setOptFlag(Integer.valueOf(0));
            List<OrderDetailEntity> detailList = orderEntity.getPurchaseOrderDetail();
            ArrayList detailThirdList = new ArrayList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.forEach(e -> {
                    if (null != e.getDetailAutomaticWeigh() && 0 == e.getDetailAutomaticWeigh()) {
                        detailThirdList.add(e);
                    }
                });
                thirdVO.setDetailList(BeanMapper.mapList(detailThirdList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (!thirdRes.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                orderEntity.setIsPushThird("unSucPush");
                orderEntity.setUnSucReason(thirdRes.getMsg());
                throw new BusinessException("\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u5931\u8d25----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a" + thirdRes.getMsg());
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
            orderEntity.setIsPushThird("sucPushed");
        }
        this.orderService.updateById((Object)orderEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        if (orderEntity.getReceiveState() == 0) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(billId));
        orderEntity.setReceiveState(null);
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        if (null != orderEntity.getAutomaticWeigh() && 0 == orderEntity.getAutomaticWeigh()) {
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)orderEntity), DeliveryThirdVO.class);
            thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress() == null ? "/" : orderEntity.getOrderAddress());
            thirdVO.setCustomerName(orderEntity.getProjectName());
            thirdVO.setOptFlag(Integer.valueOf(2));
            List<OrderDetailEntity> detailList = orderEntity.getPurchaseOrderDetail();
            ArrayList detailThirdList = new ArrayList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.forEach(e -> {
                    if (999L == e.getParentId() && null != e.getDetailAutomaticWeigh() && 0 == e.getDetailAutomaticWeigh()) {
                        detailThirdList.add(e);
                    }
                });
                thirdVO.setDetailList(BeanMapper.mapList(detailThirdList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (!thirdRes.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                orderEntity.setIsPushThird("unSucPush");
                orderEntity.setUnSucReason(thirdRes.getMsg());
            } else {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                orderEntity.setIsPushThird("sucPushed");
            }
        }
        return CommonResponse.success();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, OrderEntity orderEntity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        if (messageType.contains("weixin")) {
            channel.add("weixin");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weixin")) {
            JSONObject weixinParams = new JSONObject();
            weixinParams.put("template_id", (Object)this.templateid);
            JSONObject wxparams = new JSONObject();
            wxparams.put("first", (Object)subject);
            wxparams.put("keyword1", (Object)DateFormater.getInstance().format("yyyy-MM-dd"));
            wxparams.put("keyword2", (Object)orderEntity.getBillCode());
            wxparams.put("remark", (Object)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
            weixinParams.put("data", (Object)wxparams);
            weixinParams.put("url", (Object)(this.baseHost + "ejc-wzxt-mobile/#/supIndex/supDetails?id=" + orderEntity.getId() + "&openid={openid}"));
            parameter.setWeixinParams(weixinParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

