/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.wzxtUserProject.api.IWzxtUserProjectRelationApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseOrder"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService service;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWzxtUserProjectRelationApi wzxtUserProjectRelationApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @ApiOperation(value="\u91cd\u65b0\u63a8\u9001\u7b2c\u4e09\u65b9\u5931\u8d25\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"/PushThirdData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> savePushThirdData(@RequestParam Long id) {
        OrderVO vo = this.service.savePushThirdData(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryLatelyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryLinkDetail() {
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(OrderEntity::getEmployeeId, (Object)InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(BaseEntity::getCreateTime);
        details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(details.get(0), OrderVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList listedit = new ArrayList();
            vos.forEach(vo -> {
                List details = null;
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getOrderId, (Object)vo.getId());
                lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                details = this.orderDetailService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    details.forEach(e -> {
                        PlanDetailEntity entity = (PlanDetailEntity)((Object)((Object)((Object)this.planDetailService.getById(e.getPlanDetailId()))));
                        BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                        BigDecimal surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                        BigDecimal orderNums = e.getOrderNumsSum() == null ? BigDecimal.ZERO : e.getOrderNumsSum();
                        entity.setOccupyNums(occupyNums.subtract(orderNums));
                        entity.setSurplusNums(surplusNums.add(orderNums));
                        listedit.add(entity);
                    });
                }
            });
            if (CollectionUtils.isNotEmpty(listedit)) {
                this.planDetailService.updateBatchById(listedit);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("mobile");
        this.logger.info("\u524d\u7aef\u6807\u8bc6----" + mobile);
        if (!mobile) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            this.logger.info("\u8d70\u79fb\u52a8\u7aef\u6743\u9650\u63a5\u53e3----");
            param.getParams().remove("mobile");
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.logger.info("\u83b7\u53d6\u5230\u7528\u6237\u6743\u9650\u63a5\u53e3----" + childOrgResp.getData());
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryOrderList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryOrderList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("mobile");
        this.logger.info("\u524d\u7aef\u6807\u8bc6----" + mobile);
        if (!mobile) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            this.logger.info("\u8d70\u79fb\u52a8\u7aef\u6743\u9650\u63a5\u53e3----");
            param.getParams().remove("mobile");
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.logger.info("\u83b7\u53d6\u5230\u7528\u6237\u6743\u9650\u63a5\u53e3----" + childOrgResp.getData());
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryIgnoreNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> queryIgnoreNum(@RequestBody QueryParam param) {
        param.getParams().put("ignoreFlag", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("mobile");
        this.logger.info("\u524d\u7aef\u6807\u8bc6----" + mobile);
        if (!mobile) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            this.logger.info("\u8d70\u79fb\u52a8\u7aef\u6743\u9650\u63a5\u53e3----");
            param.getParams().remove("mobile");
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.logger.info("\u83b7\u53d6\u5230\u7528\u6237\u6743\u9650\u63a5\u53e3----" + childOrgResp.getData());
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((Object)page.getTotal());
    }

    @RequestMapping(value={"/queryUnConfirmedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnconfirmedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("receiveState", new Parameter("eq", (Object)0));
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        CommonResponse childProResp = this.projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if (!childProResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)childProResp.getData()))) {
            childIds.addAll(((List)childProResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySupplierDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> querySupplierDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        if (1 != entity.getBillState() && 3 != entity.getBillState()) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64a4\u56de\uff01");
        }
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        ArrayList listres = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getPurchaseOrderDetail())) {
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if (!vo.getLeafFlag().booleanValue()) {
                    listres.add(vo);
                }
                BigDecimal receiveNumsSum = vo.getReceiveNumsSum() == null ? BigDecimal.ZERO : vo.getReceiveNumsSum();
                BigDecimal deliverNumsSum = vo.getDeliverNumsSum() == null ? BigDecimal.ZERO : vo.getDeliverNumsSum();
                vo.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        orderVO.setBillState(Integer.valueOf(0));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)orderVO);
    }

    @RequestMapping(value={"/queryUnDeliverList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryUnDeliverList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("supplierTenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse childProResp = this.projectApi.queryProjectByUserId(InvocationInfoProxy.getUserid());
        if (!childProResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)childProResp.getData()))) {
            childIds.addAll(((List)childProResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("projectId", new Parameter("in", childIds));
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<OrderVO> list = this.service.queryUnDeliverList((Page<OrderVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, OrderVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateReceived"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.updateReceived(saveorUpdateVO));
    }

    @RequestMapping(value={"/updateIgnoreFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateIgnoreFlag(@RequestBody OrderVO orderVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(orderVO.getId()));
        orderEntity.setIgnoreFlag(orderVO.getIgnoreFlag());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.updateById((Object)orderEntity));
    }

    @RequestMapping(value={"/updateReceivedPart"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> updateReceivedPart(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.updateReceivedPart(saveorUpdateVO));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        List listExport = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (null != vo.getReceiveState() && 0 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getReceiveState() && 1 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5168\u90e8\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 2 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u90e8\u5206\u63a5\u6536");
                } else if (null != vo.getReceiveState() && 3 == vo.getReceiveState()) {
                    vo.setReceiveStateName("\u5df2\u62d2\u7edd");
                }
                if (null != vo.getDeliverState() && 0 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5f85\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 1 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u53d1\u8d27");
                } else if (null != vo.getDeliverState() && 2 == vo.getDeliverState()) {
                    vo.setDeliverStateName("\u5df2\u9a8c\u6536");
                }
            });
            listExport = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("orderExport.xlsx", beans, response);
    }
}

